/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import com.potix.doc.js.IRegion;

public class Region
implements IRegion {
    private int start;
    private int end;

    public Region(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public boolean couldUnion(IRegion r) {
        if (r.start() > this.end()) {
            return false;
        }
        return r.end() >= this.start();
    }

    public boolean hasIntersection(IRegion r) {
        if (r.start() >= this.end()) {
            return false;
        }
        return r.end() > this.start();
    }

    public static Region union(Region r1, Region r2) {
        if (!r1.hasIntersection(r2)) {
            return null;
        }
        int start = Math.max(r1.start(), r2.start());
        int end = Math.max(r1.end(), r2.end());
        return new Region(start, end);
    }

    public boolean isValid() {
        return this.start >= 0 && this.end >= 0 && this.end >= this.start;
    }
}

