/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import com.potix.doc.archive.JsTextContext;
import com.potix.doc.js.IRegion;
import com.potix.doc.js.Region;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextChunk
extends Region
implements IRegion {
    private static final Logger logger = Logger.getLogger(TextChunk.class);
    private final String textContent;
    private final JsTextContext jsContext;
    private String desc = "";
    private String type;
    private List<TextChunk> subTextChunks = new LinkedList<TextChunk>();

    public TextChunk(String type, String textContent, JsTextContext jsContext, int offset) {
        super(offset, offset + textContent.length());
        this.textContent = textContent;
        this.jsContext = jsContext;
        this.type = type;
    }

    public JsTextContext getJsTextContext() {
        return this.jsContext;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void add(TextChunk sub) {
        ArrayList<TextChunk> chks = new ArrayList<TextChunk>(this.subTextChunks);
        Collections.sort(chks, new Comparator<TextChunk>(){

            @Override
            public int compare(TextChunk o1, TextChunk o2) {
                return o1.start() - o2.start();
            }
        });
        if (TextChunk.hasConflict(sub, chks)) {
            logger.trace("addSubChunks CONFLICT! " + sub);
        } else {
            this.subTextChunks.add(sub);
        }
    }

    public List<TextChunk> getSubTextChunks() {
        return this.subTextChunks;
    }

    public void addSubChunks(Collection<TextChunk> candidates) {
        ArrayList<TextChunk> chks = new ArrayList<TextChunk>(this.subTextChunks);
        Collections.sort(chks, new Comparator<TextChunk>(){

            @Override
            public int compare(TextChunk o1, TextChunk o2) {
                return o1.start() - o2.start();
            }
        });
        LinkedList<TextChunk> ans = new LinkedList<TextChunk>();
        for (TextChunk candidate : candidates) {
            if (TextChunk.hasConflict(candidate, chks)) {
                logger.trace("addSubChunks CONFLICT! " + candidate);
                continue;
            }
            ans.add(candidate);
        }
        this.subTextChunks.addAll(ans);
    }

    public List<TextChunk> findByType(String type) {
        ArrayList<TextChunk> chks = new ArrayList<TextChunk>(this.subTextChunks);
        ArrayList<TextChunk> ans = new ArrayList<TextChunk>();
        for (TextChunk chk : chks) {
            if (!type.equals(chk.getType())) continue;
            ans.add(chk);
        }
        return ans;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String toString() {
        return " offset:" + this.start() + " end:" + this.end() + " text:" + this.getTextContent();
    }

    private static boolean hasConflict(IRegion r, Collection<? extends IRegion> exclusive) {
        for (IRegion iRegion : exclusive) {
            if (r.start() >= iRegion.end()) continue;
            if (r.end() <= iRegion.start()) {
                return false;
            }
            if (!r.couldUnion(iRegion)) continue;
            return true;
        }
        return false;
    }
}

