/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import com.potix.doc.archive.JsTextContext;
import com.potix.doc.archive.ZkClass;
import com.potix.doc.js.BracesCloseHelper;
import com.potix.doc.js.ContainerFinder;
import com.potix.doc.js.Finders;
import com.potix.doc.js.TextChunk;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WidgetClassFinder
extends ContainerFinder {
    private static final Logger logger = Logger.getLogger(WidgetClassFinder.class);
    private static final Pattern ptn = Pattern.compile("[\\r\\n][\\s]*[.\\w]+[\\s]*=[\\s]*zk\\.\\$extends[\\s]*\\([\\s]*(\\_zkf[\\s]*=[\\s]*)?+([.\\w\\s]+)\\,");
    private static final String pre = "Class";
    private static final Pattern superClassPtn = Pattern.compile("\\.\\$extends[\\s]*\\([\\s]*(\\_zkf[\\s]*=[\\s]*)?+([.\\w\\s]+)\\,");
    private static final Pattern packagePtn = Pattern.compile("[\\s]*(([\\w]+[.])+)([\\w]+)");
    private static final Pattern classNamePtn = Pattern.compile("[\\s]*([\\w]+[.])+([\\w]+)");

    protected Pattern getHeaderPattern() {
        return ptn;
    }

    protected String getPreffix() {
        return pre;
    }

    protected void parseContent(String header, TextChunk self, TextChunk chunks, JsTextContext jsContext) {
        Finders.parseSubChunk(self, jsContext);
        String wClassName = WidgetClassFinder.findClassName(header);
        String wPackage = WidgetClassFinder.findPackage(header);
        String wSuperClassName = WidgetClassFinder.findSuperClassName(header);
        ZkClass zClass = new ZkClass(wClassName, wPackage, jsContext.getLangContext());
        zClass.loadClassChunk(self, true);
        int afterIndex = self.end();
        TextChunk staticChk = this.findStaticChunk(jsContext, afterIndex);
        if (staticChk != null) {
            Finders.parseSubChunk(staticChk, jsContext);
            zClass.loadClassChunk(staticChk, false);
        }
        zClass.setSuperClassType(wSuperClassName);
        jsContext.getLangContext().appendClass(zClass);
    }

    private TextChunk findStaticChunk(JsTextContext jsContext, int afterIndex) {
        int braceBeginIdx;
        String between;
        String jsText = jsContext.getTextContent();
        TextChunk ans = null;
        int commaIdx = jsText.indexOf(",", afterIndex);
        if (commaIdx >= afterIndex && (between = jsText.substring(afterIndex, commaIdx)).trim().isEmpty() && (braceBeginIdx = jsText.indexOf("{", commaIdx)) >= commaIdx + 1 && (between = jsText.substring(commaIdx + 1, braceBeginIdx)).trim().isEmpty()) {
            int braceEndIdx = BracesCloseHelper.find(braceBeginIdx, jsText);
            String staticTextContent = jsText.substring(braceBeginIdx, braceEndIdx);
            ans = new TextChunk(this.getPreffix(), staticTextContent, jsContext, braceBeginIdx);
        }
        return ans;
    }

    private static String findSuperClassName(String textContext) {
        Matcher match = superClassPtn.matcher(textContext);
        match.find();
        return match.group(2);
    }

    private static String findPackage(String textContext) {
        Matcher match = packagePtn.matcher(textContext);
        match.find();
        String str = match.group(1);
        if (str.length() > 0) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private static String findClassName(String textContext) {
        Matcher match = classNamePtn.matcher(textContext);
        match.find();
        String str = match.group(2);
        return str;
    }
}

