/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.jsdoc;

import com.potix.doc.Generator;
import com.potix.doc.SourceCodeNode;
import com.potix.doc.Strings;
import com.potix.doc.archive.Comment;
import com.potix.doc.archive.Field;
import com.potix.doc.archive.Method;
import com.potix.doc.archive.Type;
import com.potix.doc.archive.ZkClass;
import com.potix.doc.js.TextChunk;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZKJavaScriptDocGenerator
extends Generator {
    private static final Logger logger = Logger.getLogger(ZKJavaScriptDocGenerator.class);

    @Override
    protected SourceCodeNode generateClassSrc(ZkClass aWidgetClass, SourceCodeNode root) {
        SourceCodeNode parent = this.recursiveCreateSrcNode(aWidgetClass, 0, root);
        SourceCodeNode leaf = new SourceCodeNode(aWidgetClass.getClassName() + ".java", true);
        leaf.setContent(this.generateJavaContent(aWidgetClass));
        leaf.setParent(parent);
        return leaf;
    }

    @Override
    protected SourceCodeNode generatePackageHtml(String package_, String textContent, SourceCodeNode root) {
        SourceCodeNode parent = this.recursiveCreateSrcNode(package_, 0, root);
        SourceCodeNode leaf = new SourceCodeNode("package.html", true);
        leaf.setContent(textContent);
        leaf.setParent(parent);
        return leaf;
    }

    @Override
    protected String getTranslatedPackage(ZkClass aWidgetClass) {
        String clsPackage = aWidgetClass.getPackage();
        return clsPackage.isEmpty() ? "_global_" : clsPackage;
    }

    private String generateJavaContent(ZkClass aWidgetClass) {
        StringBuffer sb = new StringBuffer();
        Strings.appendln(sb, "package ", this.getTranslatedPackage(aWidgetClass), ";");
        Strings.appendln(sb);
        Strings.appendln(sb, "import _global_.Array;");
        Strings.appendln(sb, "import _global_.Date;");
        Strings.appendln(sb, "import _global_.Dimension;");
        Strings.appendln(sb, "import _global_.DOMElement;");
        Strings.appendln(sb, "import _global_.Function;");
        Strings.appendln(sb, "import _global_.Map;");
        Strings.appendln(sb, "import _global_.Offset;");
        Strings.appendln(sb, "import _global_.Size;");
        Strings.appendln(sb, "import _global_.String;");
        Strings.appendln(sb, "import _global_.zAu;");
        Strings.appendln(sb, "import _global_.zUtl;");
        Strings.appendln(sb, "import _global_.zWatch;");
        Strings.appendln(sb, "import _global_.jqzk;");
        Strings.appendln(sb);
        for (String import_ : aWidgetClass.getImports()) {
            Strings.appendln(sb, "import ", import_, ";");
        }
        Strings.appendln(sb);
        this.generateClass(sb, aWidgetClass, "");
        return sb.toString();
    }

    private void generateClass(StringBuffer sb, ZkClass clazz, String pre) {
        if (clazz.getComments().size() > 0) {
            Comment commt = clazz.getClassComment();
            String str = commt.toClassString();
            Strings.appendln(sb, pre, str);
        }
        Strings.append(sb, pre, "public class ", clazz.getClassName());
        if (clazz.getSuperClass() != null && !clazz.getSuperClass().isEmpty()) {
            Strings.append(sb, " extends ", clazz.getSuperClass().getTypeName());
        }
        Strings.appendln(sb, pre, "{");
        Strings.appendln(sb, " ", clazz.getClassName(), "(){}");
        this.generateFileds(sb, clazz.getFields(), pre + "\t");
        Strings.appendln(sb);
        this.generateMethods(sb, clazz.getMethods(), pre + "\t");
        Strings.appendln(sb, pre, "}");
    }

    private void generateFileds(StringBuffer sb, List<Field> fields, String pre) {
        for (Field field : fields) {
            String realComment = Strings.remove("@type[\\s]+[\\w.]+", field.getComment().toString());
            Strings.appendln(sb, pre, realComment);
            if (field.isStatic()) {
                Strings.append(sb, pre, " static ");
            }
            TextChunk chk = field.getFromChk();
            String filePath = chk.getJsTextContext().getJsFilePath().replaceAll("[\\\\]", "/");
            int line = Strings.startAtLine(chk.getJsTextContext().getTextContent(), chk.start());
            Strings.appendln(sb, field.getAccessModifer(), " ", field.getFieldType(), " ", field.getFieldName(), " ; //", filePath, " line:[", line, "]");
        }
    }

    private void generateMethods(StringBuffer sb, List<Method> widgetMethods, String pre) {
        for (Method method : widgetMethods) {
            Type returnType = method.getReturnType();
            String returnTypeStr = returnType.getTypeName();
            Strings.appendln(sb, pre, method.getComment().toMethodString());
            Strings.append(sb, pre, method.getAccessModifer(), " ");
            if (method.isStatic()) {
                Strings.append(sb, " static ");
            }
            Strings.append(sb, returnTypeStr, " ", method.getSignature(), "(");
            StringBuffer sb2 = new StringBuffer();
            for (Method.Argument parm : method.getArguments()) {
                Strings.append(sb2, parm, ", ");
            }
            String params = sb2.toString();
            if (params.endsWith(", ")) {
                sb.append(params.substring(0, params.length() - 2));
            }
            Strings.appendln(sb, "){");
            if (!"void".equals(returnTypeStr)) {
                if ("int".equals(returnTypeStr) || "float".equals(returnTypeStr) || "long".equals(returnTypeStr)) {
                    Strings.appendln(sb, pre, "return 0;");
                } else if ("boolean".equals(returnTypeStr)) {
                    Strings.appendln(sb, pre, "return false;");
                } else {
                    Strings.appendln(sb, pre, "return null;");
                }
            }
            TextChunk chk = method.getFromChk();
            String filePath = chk.getJsTextContext().getJsFilePath().replaceAll("[\\\\]", "/");
            int line = Strings.startAtLine(chk.getJsTextContext().getTextContent(), chk.start());
            Strings.appendln(sb, pre, "} //", filePath, " line:[", line, "]");
        }
    }
}

