/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.pack;

import com.potix.doc.NodeIterator;
import com.potix.doc.XMLHelper;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetPackageDiscripter {
    private static final Logger logger = Logger.getLogger(WidgetPackageDiscripter.class);
    private String absolutePath;
    private String packageName;
    private String language;
    private String depends;
    private List<String> widgetJsFiles = new ArrayList<String>();

    public WidgetPackageDiscripter(String textContent, String absPath) {
        this.absolutePath = absPath;
        XMLHelper xHelper = new XMLHelper(new ByteArrayInputStream(textContent.getBytes()));
        Node wpdNode = xHelper.getNodeList("/package").item(0);
        NamedNodeMap attrs = wpdNode.getAttributes();
        this.packageName = attrs.getNamedItem("name").getTextContent();
        logger.debug("wpd packageName: " + this.packageName);
        Node node = attrs.getNamedItem("language");
        this.language = node != null ? node.getTextContent() : "xul/html";
        logger.debug("wpd language: " + this.language);
        node = attrs.getNamedItem("depends");
        if (node != null) {
            this.depends = node.getTextContent();
        }
        logger.debug("wpd depends: " + this.depends);
        new NodeIterator(){

            protected void doNode(int index, Node node) {
                NamedNodeMap attrs = node.getAttributes();
                String name = attrs.getNamedItem("name").getTextContent();
                logger.debug("wpd widget Name : " + name);
                WidgetPackageDiscripter.this.widgetJsFiles.add(name + ".js");
            }
        }.iterate(xHelper.getNodeList("/package/widget"));
        new NodeIterator(){

            protected void doNode(int index, Node node) {
                NamedNodeMap attrs = node.getAttributes();
                Node n = attrs.getNamedItem("jsdoc");
                if (n == null) {
                    return;
                }
                String jsdoc = n.getTextContent();
                if ("true".equals(jsdoc)) {
                    jsdoc = attrs.getNamedItem("src").getTextContent();
                    logger.debug("wpd script jsdoc : " + jsdoc);
                    WidgetPackageDiscripter.this.widgetJsFiles.add(jsdoc);
                }
            }
        }.iterate(xHelper.getNodeList("/package/script"));
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getPackageAsPath() {
        return this.packageName.replace(".", "/");
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDepends() {
        return this.depends;
    }

    public List<String> getWidgetJsFiles() {
        return this.widgetJsFiles;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getAbsolutePackageDir() {
        int endIndex = this.absolutePath.indexOf("zk.wpd");
        return this.absolutePath.substring(0, endIndex);
    }
}

