/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ResultSet5 {
    public static void main(String[] args) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:oracle:oci8:@", "scott", "tiger");
        Statement stmt = conn.createStatement(1005, 1008);
        stmt.setFetchSize(1);
        ResultSet rset = stmt.executeQuery("select EMPNO, ENAME, SAL from EMP");
        ResultSet5.showProperty(rset);
        System.out.println("List ENO, ENAME and SAL from the EMP table: ");
        while (rset.next()) {
            System.out.println(rset.getInt(1) + " " + rset.getString(2) + " " + rset.getInt(3));
        }
        System.out.println();
        ResultSet5.doSomeChanges(conn);
        rset.beforeFirst();
        System.out.println("List ENO, ENAME and SAL again: ");
        while (rset.next()) {
            System.out.println(rset.getInt(1) + " " + rset.getString(2) + " " + rset.getInt(3));
        }
        rset.close();
        stmt.close();
        ResultSet5.cleanup(conn);
        conn.close();
    }

    public static void doSomeChanges(Connection conn) throws SQLException {
        System.out.println("Update the employee salary outside the result set\n");
        Statement otherStmt = conn.createStatement();
        otherStmt.execute("update emp set sal = sal + 500");
        otherStmt.execute("commit");
        otherStmt.close();
    }

    public static void showProperty(ResultSet rset) throws SQLException {
        switch (rset.getType()) {
            case 1003: {
                System.out.println("Result set type: TYPE_FORWARD_ONLY");
                break;
            }
            case 1004: {
                System.out.println("Result set type: TYPE_SCROLL_INSENSITIVE");
                break;
            }
            case 1005: {
                System.out.println("Result set type: TYPE_SCROLL_SENSITIVE");
                break;
            }
            default: {
                System.out.println("Invalid type");
            }
        }
        switch (rset.getConcurrency()) {
            case 1008: {
                System.out.println("Result set concurrency: ResultSet.CONCUR_UPDATABLE");
                break;
            }
            case 1007: {
                System.out.println("Result set concurrency: ResultSet.CONCUR_READ_ONLY");
                break;
            }
            default: {
                System.out.println("Invalid type");
            }
        }
        System.out.println("fetch size: " + rset.getFetchSize());
        System.out.println();
    }

    public static void cleanup(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute("UPDATE EMP SET SAL = SAL - 500");
        stmt.execute("COMMIT");
        stmt.close();
    }
}

