/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import net.n3.nanoxml.IXMLReader;

public class StdXMLReader
implements IXMLReader {
    private Stack readers;
    private StackedReader currentReader;

    public static IXMLReader stringReader(String string) {
        return new StdXMLReader(new StringReader(string));
    }

    public static IXMLReader fileReader(String string) throws FileNotFoundException, IOException {
        StdXMLReader stdXMLReader = new StdXMLReader(new FileInputStream(string));
        stdXMLReader.setSystemID(string);
        for (int i = 0; i < stdXMLReader.readers.size(); ++i) {
            StackedReader stackedReader = (StackedReader)stdXMLReader.readers.elementAt(i);
            stackedReader.systemId = stdXMLReader.currentReader.systemId;
        }
        return stdXMLReader;
    }

    public StdXMLReader(String string, String string2) throws MalformedURLException, FileNotFoundException, IOException {
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            string2 = "file:" + string2;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                throw malformedURLException;
            }
        }
        this.currentReader = new StackedReader();
        this.readers = new Stack();
        Reader reader = this.openStream(string, uRL.toString());
        this.currentReader.lineReader = new LineNumberReader(reader);
        this.currentReader.pbReader = new PushbackReader(this.currentReader.lineReader, 2);
    }

    public StdXMLReader(Reader reader) {
        this.currentReader = new StackedReader();
        this.readers = new Stack();
        this.currentReader.lineReader = new LineNumberReader(reader);
        this.currentReader.pbReader = new PushbackReader(this.currentReader.lineReader, 2);
        this.currentReader.publicId = "";
        try {
            this.currentReader.systemId = new URL("file:.");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.currentReader.lineReader = null;
        this.currentReader.pbReader = null;
        this.currentReader.systemId = null;
        this.currentReader.publicId = null;
        this.currentReader = null;
        this.readers.clear();
        super.finalize();
    }

    protected String getEncoding(String string) {
        if (!string.startsWith("<?xml")) {
            return null;
        }
        int n = 5;
        while (n < string.length()) {
            char c;
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            while (n < string.length() && string.charAt(n) <= ' ') {
                ++n;
            }
            while (n < string.length() && string.charAt(n) >= 'a' && string.charAt(n) <= 'z') {
                stringBuffer.append(string.charAt(n));
                ++n;
            }
            while (n < string.length() && string.charAt(n) <= ' ') {
                ++n;
            }
            if (n >= string.length() || string.charAt(n) != '=') break;
            while (n < string.length() && string.charAt(n) != '\'' && string.charAt(n) != '\"') {
                ++n;
            }
            if (n >= string.length() || (n2 = string.indexOf(c = string.charAt(n), ++n)) < 0) break;
            if (stringBuffer.toString().equals("encoding")) {
                return string.substring(n, n2);
            }
            n = n2 + 1;
        }
        return null;
    }

    protected Reader stream2reader(InputStream inputStream, StringBuffer stringBuffer) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        int n = pushbackInputStream.read();
        switch (n) {
            case 0: 
            case 254: 
            case 255: {
                pushbackInputStream.unread(n);
                return new InputStreamReader((InputStream)pushbackInputStream, "UTF-16");
            }
            case 239: {
                for (int i = 0; i < 2; ++i) {
                    pushbackInputStream.read();
                }
                return new InputStreamReader((InputStream)pushbackInputStream, "UTF-8");
            }
            case 60: {
                String string;
                n = pushbackInputStream.read();
                stringBuffer.append('<');
                while (n > 0 && n != 62) {
                    stringBuffer.append((char)n);
                    n = pushbackInputStream.read();
                }
                if (n > 0) {
                    stringBuffer.append((char)n);
                }
                if ((string = this.getEncoding(stringBuffer.toString())) == null) {
                    return new InputStreamReader((InputStream)pushbackInputStream, "UTF-8");
                }
                stringBuffer.setLength(0);
                try {
                    return new InputStreamReader((InputStream)pushbackInputStream, string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return new InputStreamReader((InputStream)pushbackInputStream, "UTF-8");
                }
            }
        }
        stringBuffer.append((char)n);
        return new InputStreamReader((InputStream)pushbackInputStream, "UTF-8");
    }

    public StdXMLReader(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        Reader reader = this.stream2reader(inputStream, stringBuffer);
        this.currentReader = new StackedReader();
        this.readers = new Stack();
        this.currentReader.lineReader = new LineNumberReader(reader);
        this.currentReader.pbReader = new PushbackReader(this.currentReader.lineReader, 2);
        this.currentReader.publicId = "";
        try {
            this.currentReader.systemId = new URL("file:.");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.startNewStream(new StringReader(stringBuffer.toString()));
    }

    public char read() throws IOException {
        int n = this.currentReader.pbReader.read();
        while (n < 0) {
            if (this.readers.empty()) {
                throw new IOException("Unexpected EOF");
            }
            this.currentReader.pbReader.close();
            this.currentReader = (StackedReader)this.readers.pop();
            n = this.currentReader.pbReader.read();
        }
        return (char)n;
    }

    public boolean atEOFOfCurrentStream() throws IOException {
        int n = this.currentReader.pbReader.read();
        if (n < 0) {
            return true;
        }
        this.currentReader.pbReader.unread(n);
        return false;
    }

    public boolean atEOF() throws IOException {
        int n = this.currentReader.pbReader.read();
        while (n < 0) {
            if (this.readers.empty()) {
                return true;
            }
            this.currentReader.pbReader.close();
            this.currentReader = (StackedReader)this.readers.pop();
            n = this.currentReader.pbReader.read();
        }
        this.currentReader.pbReader.unread(n);
        return false;
    }

    public void unread(char c) throws IOException {
        this.currentReader.pbReader.unread(c);
    }

    public Reader openStream(String string, String string2) throws MalformedURLException, FileNotFoundException, IOException {
        CharSequence charSequence;
        URL uRL = new URL(this.currentReader.systemId, string2);
        if (uRL.getRef() != null) {
            charSequence = uRL.getRef();
            if (uRL.getFile().length() > 0) {
                uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile());
                uRL = new URL("jar:" + uRL + '!' + (String)charSequence);
            } else {
                uRL = StdXMLReader.class.getResource((String)charSequence);
            }
        }
        this.currentReader.publicId = string;
        this.currentReader.systemId = uRL;
        charSequence = new StringBuffer();
        Reader reader = this.stream2reader(uRL.openStream(), (StringBuffer)charSequence);
        if (((StringBuffer)charSequence).length() == 0) {
            return reader;
        }
        String string3 = ((StringBuffer)charSequence).toString();
        PushbackReader pushbackReader = new PushbackReader(reader, string3.length());
        for (int i = string3.length() - 1; i >= 0; --i) {
            pushbackReader.unread(string3.charAt(i));
        }
        return pushbackReader;
    }

    public void startNewStream(Reader reader) {
        this.startNewStream(reader, false);
    }

    public void startNewStream(Reader reader, boolean bl) {
        StackedReader stackedReader = this.currentReader;
        this.readers.push(this.currentReader);
        this.currentReader = new StackedReader();
        if (bl) {
            this.currentReader.lineReader = null;
            this.currentReader.pbReader = new PushbackReader(reader, 2);
        } else {
            this.currentReader.lineReader = new LineNumberReader(reader);
            this.currentReader.pbReader = new PushbackReader(this.currentReader.lineReader, 2);
        }
        this.currentReader.systemId = stackedReader.systemId;
        this.currentReader.publicId = stackedReader.publicId;
    }

    public int getStreamLevel() {
        return this.readers.size();
    }

    public int getLineNr() {
        if (this.currentReader.lineReader == null) {
            StackedReader stackedReader = (StackedReader)this.readers.peek();
            if (stackedReader.lineReader == null) {
                return 0;
            }
            return stackedReader.lineReader.getLineNumber() + 1;
        }
        return this.currentReader.lineReader.getLineNumber() + 1;
    }

    public void setSystemID(String string) throws MalformedURLException {
        this.currentReader.systemId = new URL(this.currentReader.systemId, string);
    }

    public void setPublicID(String string) {
        this.currentReader.publicId = string;
    }

    public String getSystemID() {
        return this.currentReader.systemId.toString();
    }

    public String getPublicID() {
        return this.currentReader.publicId;
    }

    private class StackedReader {
        PushbackReader pbReader;
        LineNumberReader lineReader;
        URL systemId;
        String publicId;

        private StackedReader() {
        }
    }
}

