/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jhotdraw.draw.AbstractCompositeFigure;
import org.jhotdraw.draw.AttributeChangeEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttributedCompositeFigure
extends AbstractCompositeFigure {
    private HashMap<AttributeKey, Object> attributes = new HashMap();
    private HashSet<AttributeKey> forbiddenAttributes;

    @Override
    public void setAttribute(AttributeKey attributeKey, Object object) {
        if (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(attributeKey)) {
            Object object2 = this.attributes.get(attributeKey);
            if (!this.attributes.containsKey(attributeKey) || object2 != object || object2 != null && object != null && !object2.equals(object)) {
                this.willChange();
                this.basicSetAttribute(attributeKey, object);
                this.fireAttributeChanged(attributeKey, object2, object);
                this.fireUndoableEditHappened(new AttributeChangeEdit(this, attributeKey, object2, object));
                this.changed();
            }
        }
    }

    public void setAttributeEnabled(AttributeKey attributeKey, boolean bl) {
        if (this.forbiddenAttributes == null) {
            this.forbiddenAttributes = new HashSet();
        }
        if (bl) {
            this.forbiddenAttributes.remove(attributeKey);
        } else {
            this.forbiddenAttributes.add(attributeKey);
        }
    }

    public boolean isAttributeEnabled(AttributeKey attributeKey) {
        return this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(attributeKey);
    }

    public void setAttributes(HashMap<AttributeKey, Object> hashMap) {
        for (Map.Entry<AttributeKey, Object> entry : hashMap.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>(this.attributes);
    }

    @Override
    public void basicSetAttribute(AttributeKey attributeKey, Object object) {
        if (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(attributeKey)) {
            this.attributes.put(attributeKey, object);
        }
        this.basicSetAttributeOnChildren(attributeKey, object);
    }

    protected void basicSetAttributeOnChildren(AttributeKey attributeKey, Object object) {
        for (Figure figure : this.getChildren()) {
            figure.basicSetAttribute(attributeKey, object);
        }
    }

    @Override
    public Object getAttribute(AttributeKey attributeKey) {
        return this.hasAttribute(attributeKey) ? this.attributes.get(attributeKey) : attributeKey.getDefaultValue();
    }

    @Override
    public void drawFigure(Graphics2D graphics2D) {
        this.drawChildren(graphics2D);
        if (AttributeKeys.FILL_COLOR.get(this) != null) {
            graphics2D.setColor(AttributeKeys.FILL_COLOR.get(this));
            this.drawFill(graphics2D);
        }
        if (AttributeKeys.STROKE_COLOR.get(this) != null && AttributeKeys.STROKE_WIDTH.get(this) > 0.0) {
            graphics2D.setStroke(AttributeKeys.getStroke(this));
            graphics2D.setColor(AttributeKeys.STROKE_COLOR.get(this));
            this.drawStroke(graphics2D);
        }
        if (AttributeKeys.TEXT_COLOR.get(this) != null) {
            if (AttributeKeys.TEXT_SHADOW_COLOR.get(this) != null && AttributeKeys.TEXT_SHADOW_OFFSET.get(this) != null) {
                Dimension2DDouble dimension2DDouble = AttributeKeys.TEXT_SHADOW_OFFSET.get(this);
                graphics2D.translate(dimension2DDouble.width, dimension2DDouble.height);
                graphics2D.setColor(AttributeKeys.TEXT_SHADOW_COLOR.get(this));
                this.drawText(graphics2D);
                graphics2D.translate(-dimension2DDouble.width, -dimension2DDouble.height);
            }
            graphics2D.setColor(AttributeKeys.TEXT_COLOR.get(this));
            this.drawText(graphics2D);
        }
        if (this.isConnectorsVisible()) {
            this.drawConnectors(graphics2D);
        }
    }

    protected void drawChildren(Graphics2D graphics2D) {
        for (Figure figure : this.getChildren()) {
            figure.draw(graphics2D);
        }
    }

    @Override
    protected void drawConnectors(Graphics2D graphics2D) {
    }

    public Stroke getStroke() {
        return AttributeKeys.getStroke(this);
    }

    public double getStrokeMiterLimitFactor() {
        Number number = (Number)this.getAttribute(AttributeKeys.STROKE_MITER_LIMIT_FACTOR);
        return number != null ? number.doubleValue() : 10.0;
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        double d = AttributeKeys.getStrokeTotalWidth(this) / 2.0;
        if (AttributeKeys.STROKE_JOIN.get(this) == 0) {
            d *= AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this).doubleValue();
        }
        Rectangle2D.Double double_ = this.getBounds();
        Geom.grow(double_, d += 1.0, d);
        return double_;
    }

    protected abstract void drawFill(Graphics2D var1);

    protected abstract void drawStroke(Graphics2D var1);

    protected void drawText(Graphics2D graphics2D) {
    }

    @Override
    public AbstractAttributedCompositeFigure clone() {
        AbstractAttributedCompositeFigure abstractAttributedCompositeFigure = (AbstractAttributedCompositeFigure)super.clone();
        abstractAttributedCompositeFigure.attributes = new HashMap<AttributeKey, Object>(this.attributes);
        if (this.forbiddenAttributes != null) {
            abstractAttributedCompositeFigure.forbiddenAttributes = new HashSet<AttributeKey>(this.forbiddenAttributes);
        }
        return abstractAttributedCompositeFigure;
    }

    protected void writeAttributes(DOMOutput dOMOutput) throws IOException {
        Figure figure = (Figure)dOMOutput.getPrototype();
        boolean bl = false;
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            Object t;
            Object t2;
            AttributeKey attributeKey = entry.getKey();
            if (this.forbiddenAttributes != null && this.forbiddenAttributes.contains(attributeKey) || (t2 = attributeKey.get(figure)) == (t = attributeKey.get(this)) && (t2 == null || t == null || t2.equals(t))) continue;
            if (!bl) {
                dOMOutput.openElement("a");
                bl = true;
            }
            dOMOutput.openElement(attributeKey.getKey());
            dOMOutput.writeObject(entry.getValue());
            dOMOutput.closeElement();
        }
        if (bl) {
            dOMOutput.closeElement();
        }
    }

    protected void readAttributes(DOMInput dOMInput) throws IOException {
        if (dOMInput.getElementCount("a") > 0) {
            dOMInput.openElement("a");
            for (int i = dOMInput.getElementCount() - 1; i >= 0; --i) {
                dOMInput.openElement(i);
                String string = dOMInput.getTagName();
                Object object = dOMInput.readObject();
                AttributeKey attributeKey = this.getAttributeKey(string);
                if (attributeKey != null && attributeKey.isAssignable(object) && (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(attributeKey))) {
                    this.setAttribute(attributeKey, object);
                }
                dOMInput.closeElement();
            }
            dOMInput.closeElement();
        }
    }

    protected AttributeKey getAttributeKey(String string) {
        return AttributeKeys.supportedAttributeMap.get(string);
    }

    protected void applyAttributesTo(Figure figure) {
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            figure.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        super.write(dOMOutput);
        this.writeAttributes(dOMOutput);
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        super.read(dOMInput);
        this.readAttributes(dOMInput);
    }

    @Override
    public void removeAttribute(AttributeKey attributeKey) {
        if (this.hasAttribute(attributeKey)) {
            Object object = this.getAttribute(attributeKey);
            this.attributes.remove(attributeKey);
            this.fireAttributeChanged(attributeKey, object, attributeKey.getDefaultValue());
        }
    }

    @Override
    public boolean hasAttribute(AttributeKey attributeKey) {
        return this.attributes.containsKey(attributeKey);
    }
}

