/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Layouter;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompositeFigure
extends AbstractFigure
implements CompositeFigure {
    private LinkedList<Figure> children = new LinkedList();
    private Rectangle2D.Double drawBounds;
    private Rectangle2D.Double bounds;
    private Layouter layouter;
    private ChildHandler childHandler = new ChildHandler(this);

    @Override
    public Collection<Handle> createHandles(int n) {
        if (n == 0) {
            return super.createHandles(0);
        }
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        return linkedList;
    }

    @Override
    public void add(Figure figure) {
        this.add(this.getChildCount(), figure);
    }

    @Override
    public void add(int n, Figure figure) {
        this.willChange();
        this.basicAdd(n, figure);
        if (this.getDrawing() != null) {
            figure.addNotify(this.getDrawing());
        }
        this.changed();
    }

    public void addAll(Collection<Figure> collection) {
        this.willChange();
        for (Figure figure : collection) {
            this.basicAdd(this.getChildCount(), figure);
            if (this.getDrawing() == null) continue;
            figure.addNotify(this.getDrawing());
        }
        this.changed();
    }

    @Override
    public void basicAdd(Figure figure) {
        this.basicAdd(this.getChildCount(), figure);
    }

    @Override
    public void basicAdd(int n, Figure figure) {
        this.children.add(n, figure);
        figure.addFigureListener(this.childHandler);
        figure.addUndoableEditListener(this.childHandler);
    }

    public void basicAddAll(Collection<Figure> collection) {
        for (Figure figure : collection) {
            this.basicAdd(this.getChildCount(), figure);
        }
    }

    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        for (Figure figure : this.children) {
            figure.addNotify(drawing);
        }
    }

    @Override
    public void removeNotify(Drawing drawing) {
        for (Figure figure : new LinkedList<Figure>(this.children)) {
            figure.removeNotify(drawing);
        }
        super.removeNotify(drawing);
    }

    @Override
    public boolean remove(Figure figure) {
        int n = this.children.indexOf(figure);
        if (n == -1) {
            return false;
        }
        this.willChange();
        this.basicRemoveChild(n);
        if (this.getDrawing() != null) {
            figure.removeNotify(this.getDrawing());
        }
        this.changed();
        return true;
    }

    @Override
    public Figure removeChild(int n) {
        this.willChange();
        Figure figure = this.basicRemoveChild(n);
        if (this.getDrawing() != null) {
            figure.removeNotify(this.getDrawing());
        }
        this.changed();
        return figure;
    }

    @Override
    public boolean basicRemove(Figure figure) {
        int n = this.children.indexOf(figure);
        if (n == -1) {
            return false;
        }
        this.basicRemoveChild(n);
        return true;
    }

    @Override
    public Figure basicRemoveChild(int n) {
        Figure figure = this.children.remove(n);
        figure.removeFigureListener(this.childHandler);
        figure.removeUndoableEditListener(this.childHandler);
        return figure;
    }

    @Override
    public void removeAllChildren() {
        this.willChange();
        while (this.children.size() > 0) {
            Figure figure = this.basicRemoveChild(this.children.size() - 1);
            if (this.getDrawing() == null) continue;
            figure.addNotify(this.getDrawing());
        }
        this.changed();
    }

    @Override
    public void basicRemoveAllChildren() {
        while (this.children.size() > 0) {
            Figure figure = this.basicRemoveChild(this.children.size() - 1);
        }
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.children.remove(figure)) {
            this.children.add(0, figure);
            figure.invalidate();
        }
    }

    public synchronized void sendToFront(Figure figure) {
        if (this.children.remove(figure)) {
            this.children.add(figure);
            figure.invalidate();
        }
    }

    @Override
    public void basicTransform(AffineTransform affineTransform) {
        for (Figure figure : this.children) {
            figure.basicTransform(affineTransform);
        }
        this.invalidateBounds();
    }

    @Override
    public void basicSetBounds(Point2D.Double double_, Point2D.Double double_2) {
        Rectangle2D.Double double_3 = this.getBounds();
        Rectangle2D.Double double_4 = new Rectangle2D.Double(Math.min(double_.x, double_2.x), Math.min(double_.y, double_2.y), Math.abs(double_.x - double_2.x), Math.abs(double_.y - double_2.y));
        double d = double_4.width / double_3.width;
        double d2 = double_4.height / double_3.height;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-double_3.x, -double_3.y);
        if (!(Double.isNaN(d) || Double.isNaN(d2) || d == 1.0 && d2 == 1.0 || d < 1.0E-4 || d2 < 1.0E-4)) {
            this.basicTransform(affineTransform);
            affineTransform.setToIdentity();
            affineTransform.scale(d, d2);
            this.basicTransform(affineTransform);
            affineTransform.setToIdentity();
        }
        affineTransform.translate(double_4.x, double_4.y);
        this.basicTransform(affineTransform);
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.fireUndoableEditHappened(undoableEditEvent.getEdit());
    }

    @Override
    public List<Figure> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public Figure getChild(int n) {
        return this.children.get(n);
    }

    public List<Figure> getChildrenFrontToBack() {
        return this.children == null ? new LinkedList() : new ReversedList<Figure>(this.children);
    }

    @Override
    public void setAttribute(AttributeKey attributeKey, Object object) {
        this.willChange();
        for (Figure figure : this.children) {
            figure.setAttribute(attributeKey, object);
        }
        this.changed();
    }

    @Override
    public void basicSetAttribute(AttributeKey attributeKey, Object object) {
        for (Figure figure : this.children) {
            figure.basicSetAttribute(attributeKey, object);
        }
    }

    @Override
    public Object getAttribute(AttributeKey attributeKey) {
        return null;
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        if (this.getDrawBounds().contains(double_)) {
            for (Figure figure : this.getChildrenFrontToBack()) {
                if (!figure.isVisible() || !figure.contains(double_)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Figure findFigureInside(Point2D.Double double_) {
        if (this.getDrawBounds().contains(double_)) {
            Figure figure = null;
            for (Figure figure2 : this.getChildrenFrontToBack()) {
                if (!figure2.isVisible() || (figure = figure2.findFigureInside(double_)) == null) continue;
                return figure;
            }
        }
        return null;
    }

    public Figure findChild(Point2D.Double double_) {
        if (this.getBounds().contains(double_)) {
            Object var2_2 = null;
            for (Figure figure : this.getChildrenFrontToBack()) {
                if (!figure.isVisible() || !figure.contains(double_)) continue;
                return figure;
            }
        }
        return null;
    }

    public int findChildIndex(Point2D.Double double_) {
        Figure figure = this.findChild(double_);
        return figure == null ? -1 : this.children.indexOf(figure);
    }

    @Override
    public Layouter getLayouter() {
        return this.layouter;
    }

    @Override
    public void layout() {
        if (this.getLayouter() != null) {
            Rectangle2D.Double double_ = this.getBounds();
            Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
            Rectangle2D.Double double_3 = this.getLayouter().layout(this, double_2, double_2);
            this.basicSetBounds(new Point2D.Double(double_3.x, double_3.y), new Point2D.Double(double_3.x + double_3.width, double_3.y + double_3.height));
            this.invalidateBounds();
        }
    }

    @Override
    public void setLayouter(Layouter layouter) {
        this.layouter = layouter;
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        if (this.layouter != null) {
            Rectangle2D.Double double_ = this.layouter.calculateLayout(this, this.getStartPoint(), this.getEndPoint());
            return new Dimension2DDouble(double_.width, double_.height);
        }
        return super.getPreferredSize();
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        if (this.drawBounds == null) {
            for (Figure figure : this.getChildrenFrontToBack()) {
                Rectangle2D.Double double_;
                if (!figure.isVisible() || (double_ = figure.getDrawBounds()).isEmpty()) continue;
                if (this.drawBounds == null) {
                    this.drawBounds = double_;
                    continue;
                }
                this.drawBounds.add(double_);
            }
        }
        return this.drawBounds == null ? new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0) : (Rectangle2D.Double)this.drawBounds.clone();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            for (Figure figure : this.getChildrenFrontToBack()) {
                if (!figure.isVisible()) continue;
                if (this.bounds == null) {
                    this.bounds = figure.getBounds();
                    continue;
                }
                this.bounds.add(figure.getBounds());
            }
        }
        return this.bounds == null ? new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0) : (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public void drawFigure(Graphics2D graphics2D) {
        for (Figure figure : this.children) {
            if (!figure.isVisible()) continue;
            figure.draw(graphics2D);
        }
        if (this.isConnectorsVisible()) {
            this.drawConnectors(graphics2D);
        }
    }

    protected void drawConnectors(Graphics2D graphics2D) {
    }

    @Override
    public AbstractCompositeFigure clone() {
        AbstractCompositeFigure abstractCompositeFigure = (AbstractCompositeFigure)super.clone();
        abstractCompositeFigure.childHandler = new ChildHandler(abstractCompositeFigure);
        abstractCompositeFigure.children = new LinkedList();
        for (Figure figure : this.children) {
            Figure figure2 = (Figure)figure.clone();
            abstractCompositeFigure.children.add(figure2);
            figure2.addFigureListener(abstractCompositeFigure.childHandler);
            figure2.addUndoableEditListener(abstractCompositeFigure.childHandler);
        }
        return abstractCompositeFigure;
    }

    protected void invalidateBounds() {
        this.bounds = null;
        this.drawBounds = null;
    }

    @Override
    public Collection<Figure> getDecomposition() {
        LinkedList<Figure> linkedList = new LinkedList<Figure>();
        linkedList.add(this);
        linkedList.addAll(this.getChildren());
        return linkedList;
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        dOMInput.openElement("children");
        for (int i = 0; i < dOMInput.getElementCount(); ++i) {
            this.add((Figure)dOMInput.readObject(i));
        }
        dOMInput.closeElement();
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        dOMOutput.openElement("children");
        for (Figure figure : this.getChildren()) {
            dOMOutput.writeObject(figure);
        }
        dOMOutput.closeElement();
    }

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>();
    }

    @Override
    public void restoreTo(Object object) {
        LinkedList linkedList = (LinkedList)object;
        int n = 0;
        for (Object e : linkedList) {
            this.getChild(n).restoreTo(e);
            ++n;
        }
        this.invalidateBounds();
    }

    @Override
    public Object getRestoreData() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Figure figure : this.children) {
            linkedList.add(figure.getRestoreData());
        }
        return linkedList;
    }

    @Override
    public void willChange() {
        super.willChange();
        if (this.getChangingDepth() == 1) {
            for (Figure figure : this.children) {
                figure.willChange();
            }
        }
    }

    @Override
    public void changed() {
        if (this.getChangingDepth() == 1) {
            for (Figure figure : this.children) {
                figure.changed();
            }
        }
        super.changed();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invalidateBounds();
    }

    @Override
    protected void validate() {
        super.validate();
        this.layout();
        this.invalidateBounds();
    }

    public void removeAttribute(AttributeKey attributeKey) {
    }

    public boolean hasAttribute(AttributeKey attributeKey) {
        return false;
    }

    private static class ChildHandler
    implements FigureListener,
    UndoableEditListener {
        private AbstractCompositeFigure owner;

        private ChildHandler(AbstractCompositeFigure abstractCompositeFigure) {
            this.owner = abstractCompositeFigure;
        }

        public void figureRequestRemove(FigureEvent figureEvent) {
            this.owner.remove(figureEvent.getFigure());
        }

        public void figureRemoved(FigureEvent figureEvent) {
        }

        public void figureChanged(FigureEvent figureEvent) {
            if (!this.owner.isChanging()) {
                this.owner.willChange();
                this.owner.fireFigureChanged(figureEvent);
                this.owner.changed();
            }
        }

        public void figureAdded(FigureEvent figureEvent) {
        }

        public void figureAttributeChanged(FigureEvent figureEvent) {
        }

        public void figureAreaInvalidated(FigureEvent figureEvent) {
            if (!this.owner.isChanging()) {
                this.owner.fireAreaInvalidated(figureEvent.getInvalidatedArea());
            }
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            this.owner.fireUndoableEditHappened(undoableEditEvent.getEdit());
        }
    }
}

