/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class AbstractConnector
implements Connector {
    private Figure owner;
    private boolean isConnectToDecorator;
    private boolean isVisible;
    private boolean isStatePersistent;

    public AbstractConnector() {
        this.owner = null;
    }

    public AbstractConnector(Figure figure) {
        this.owner = figure;
    }

    public void setConnectToDecorator(boolean bl) {
        this.isConnectToDecorator = bl;
    }

    public boolean isConnectToDecorator() {
        return this.isConnectToDecorator;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    protected final Figure getConnectorTarget(Figure figure) {
        return this.isConnectToDecorator && figure.getDecorator() != null ? figure.getDecorator() : figure;
    }

    public boolean contains(Point2D.Double double_) {
        return this.getOwner().contains(double_);
    }

    public void draw(Graphics2D graphics2D) {
        if (this.isVisible) {
            Rectangle2D.Double double_ = this.getBounds();
            Ellipse2D.Double double_2 = new Ellipse2D.Double(double_.x + double_.width / 2.0 - 3.0, double_.y + double_.height / 2.0 - 3.0, 6.0, 6.0);
            graphics2D.setColor(Color.blue);
            graphics2D.fill(double_2);
        }
    }

    public Point2D.Double findStart(ConnectionFigure connectionFigure) {
        return this.findPoint(connectionFigure);
    }

    public Point2D.Double findEnd(ConnectionFigure connectionFigure) {
        return this.findPoint(connectionFigure);
    }

    protected Point2D.Double findPoint(ConnectionFigure connectionFigure) {
        return Geom.center(this.getBounds());
    }

    public Rectangle2D.Double getBounds() {
        return this.getOwner().getBounds();
    }

    public Figure getOwner() {
        return this.owner;
    }

    protected void setOwner(Figure figure) {
        this.owner = figure;
    }

    public Object clone() {
        try {
            AbstractConnector abstractConnector = (AbstractConnector)super.clone();
            return abstractConnector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            InternalError internalError = new InternalError(cloneNotSupportedException.toString());
            throw internalError;
        }
    }

    public void updateStartLocation(Point2D.Double double_) {
    }

    public void updateEndLocation(Point2D.Double double_) {
    }

    public Point2D.Double getAnchor() {
        return Geom.center(this.getBounds());
    }

    public void updateAnchor(Point2D.Double double_) {
    }

    public void read(DOMInput dOMInput) throws IOException {
        if (this.isStatePersistent) {
            this.isConnectToDecorator = dOMInput.getAttribute("connectToDecorator", false);
            this.isVisible = dOMInput.getAttribute("visible", false);
        }
        dOMInput.openElement("owner");
        this.owner = (Figure)dOMInput.readObject(0);
        dOMInput.closeElement();
    }

    public void write(DOMOutput dOMOutput) throws IOException {
        if (this.isStatePersistent) {
            if (this.isConnectToDecorator) {
                dOMOutput.addAttribute("connectToDecorator", true);
            }
            if (this.isVisible) {
                dOMOutput.addAttribute("visible", true);
            }
        }
        dOMOutput.openElement("owner");
        dOMOutput.writeObject(this.getOwner());
        dOMOutput.closeElement();
    }
}

