/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEvent;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDrawing
extends AbstractBean
implements Drawing {
    private static final Object lock = new JPanel().getTreeLock();
    protected EventListenerList listenerList = new EventListenerList();
    private FontRenderContext fontRenderContext;

    @Override
    public void addDrawingListener(DrawingListener drawingListener) {
        this.listenerList.add(DrawingListener.class, drawingListener);
    }

    @Override
    public void removeDrawingListener(DrawingListener drawingListener) {
        this.listenerList.remove(DrawingListener.class, drawingListener);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.add(UndoableEditListener.class, undoableEditListener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.remove(UndoableEditListener.class, undoableEditListener);
    }

    @Override
    public void addAll(Collection<Figure> collection) {
        CompositeEdit compositeEdit = new CompositeEdit("Figuren hinzuf\u00fcgen");
        this.fireUndoableEditHappened(compositeEdit);
        for (Figure figure : collection) {
            this.add(figure);
        }
        this.fireUndoableEditHappened(compositeEdit);
    }

    @Override
    public void clear() {
        this.removeAll(this.getFigures());
    }

    @Override
    public int getFigureCount() {
        return this.getFigures().size();
    }

    @Override
    public void removeAll(Collection<Figure> collection) {
        CompositeEdit compositeEdit = new CompositeEdit("Figuren entfernen");
        this.fireUndoableEditHappened(compositeEdit);
        for (Figure figure : new ArrayList<Figure>(collection)) {
            this.remove(figure);
        }
        this.fireUndoableEditHappened(compositeEdit);
    }

    @Override
    public void basicAddAll(Collection<Figure> collection) {
        for (Figure figure : collection) {
            this.basicAdd(figure);
        }
    }

    @Override
    public void basicRemoveAll(Collection<Figure> collection) {
        for (Figure figure : new ArrayList<Figure>(collection)) {
            this.basicRemove(figure);
        }
    }

    @Override
    public final void add(final Figure figure) {
        final int n = this.getFigureCount();
        this.basicAdd(n, figure);
        figure.addNotify(this);
        this.fireFigureAdded(figure);
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            public String getPresentationName() {
                return "Figur einf\u00fcgen";
            }

            public void undo() throws CannotUndoException {
                super.undo();
                AbstractDrawing.this.basicRemove(figure);
                figure.removeNotify(AbstractDrawing.this);
                AbstractDrawing.this.fireFigureRemoved(figure);
            }

            public void redo() throws CannotUndoException {
                super.redo();
                AbstractDrawing.this.basicAdd(n, figure);
                figure.addNotify(AbstractDrawing.this);
                AbstractDrawing.this.fireFigureAdded(figure);
            }
        });
    }

    @Override
    public void basicAdd(Figure figure) {
        this.basicAdd(this.getFigureCount(), figure);
    }

    @Override
    public final void remove(final Figure figure) {
        if (this.contains(figure)) {
            final int n = this.indexOf(figure);
            this.basicRemove(figure);
            figure.removeNotify(this);
            this.fireFigureRemoved(figure);
            this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                public String getPresentationName() {
                    return "Figur entfernen";
                }

                public void redo() throws CannotUndoException {
                    super.redo();
                    AbstractDrawing.this.basicRemove(figure);
                    figure.removeNotify(AbstractDrawing.this);
                    AbstractDrawing.this.fireFigureRemoved(figure);
                }

                public void undo() throws CannotUndoException {
                    super.undo();
                    AbstractDrawing.this.basicAdd(n, figure);
                    figure.addNotify(AbstractDrawing.this);
                    AbstractDrawing.this.fireFigureAdded(figure);
                }
            });
        } else {
            this.fireAreaInvalidated(figure.getDrawBounds());
        }
    }

    protected abstract int indexOf(Figure var1);

    protected void fireAreaInvalidated(Rectangle2D.Double double_) {
        DrawingEvent drawingEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DrawingListener.class) continue;
            if (drawingEvent == null) {
                drawingEvent = new DrawingEvent(this, null, double_);
            }
            ((DrawingListener)objectArray[i + 1]).areaInvalidated(drawingEvent);
        }
    }

    @Override
    public void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        UndoableEditEvent undoableEditEvent = null;
        if (this.listenerList.getListenerCount() > 0) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (undoableEditEvent == null) {
                    undoableEditEvent = new UndoableEditEvent(this, undoableEdit);
                }
                if (objectArray[i] != UndoableEditListener.class) continue;
                ((UndoableEditListener)objectArray[i + 1]).undoableEditHappened(undoableEditEvent);
            }
        }
    }

    protected void fireFigureAdded(Figure figure) {
        DrawingEvent drawingEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DrawingListener.class) continue;
            if (drawingEvent == null) {
                drawingEvent = new DrawingEvent(this, figure, figure.getDrawBounds());
            }
            ((DrawingListener)objectArray[i + 1]).figureAdded(drawingEvent);
        }
    }

    protected void fireFigureRemoved(Figure figure) {
        DrawingEvent drawingEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DrawingListener.class) continue;
            if (drawingEvent == null) {
                drawingEvent = new DrawingEvent(this, figure, figure.getDrawBounds());
            }
            ((DrawingListener)objectArray[i + 1]).figureRemoved(drawingEvent);
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    @Override
    public void setFontRenderContext(FontRenderContext fontRenderContext) {
        this.fontRenderContext = fontRenderContext;
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        dOMInput.openElement("figures");
        for (int i = 0; i < dOMInput.getElementCount(); ++i) {
            Figure figure = (Figure)dOMInput.readObject(i);
            this.add(figure);
        }
        dOMInput.closeElement();
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        dOMOutput.openElement("figures");
        for (Figure figure : this.getFigures()) {
            dOMOutput.writeObject(figure);
        }
        dOMOutput.closeElement();
    }

    @Override
    public Object getLock() {
        return lock;
    }
}

