/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.GeneralPath;
import org.jhotdraw.draw.AbstractLineDecoration;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

public class ArrowTip
extends AbstractLineDecoration
implements DOMStorable {
    private double angle;
    private double outerRadius;
    private double innerRadius;

    public ArrowTip() {
        this(0.35, 12.0, 11.3);
    }

    public ArrowTip(double d, double d2, double d3) {
        this(d, d2, d3, true, false, true);
    }

    public ArrowTip(double d, double d2, double d3, boolean bl, boolean bl2, boolean bl3) {
        super(bl, bl2, bl3);
        this.angle = d;
        this.outerRadius = d2;
        this.innerRadius = d3;
    }

    protected GeneralPath getDecoratorPath(Figure figure) {
        double d = this.isStroked() ? 1.0 : 0.0;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(this.outerRadius * Math.sin(-this.angle)), (float)(d + this.outerRadius * Math.cos(-this.angle)));
        generalPath.lineTo(0.0f, (float)d);
        generalPath.lineTo((float)(this.outerRadius * Math.sin(this.angle)), (float)(d + this.outerRadius * Math.cos(this.angle)));
        if (this.innerRadius != 0.0) {
            generalPath.lineTo(0.0f, (float)(this.innerRadius + d));
            generalPath.closePath();
        }
        return generalPath;
    }

    protected double getDecoratorPathRadius(Figure figure) {
        double d = this.isStroked() ? 0.5 : -0.1;
        return this.innerRadius + d;
    }

    public void read(DOMInput dOMInput) {
        this.angle = dOMInput.getAttribute("angle", 0.35f);
        this.innerRadius = dOMInput.getAttribute("innerRadius", 12.0);
        this.outerRadius = dOMInput.getAttribute("outerRadius", 12.0);
        this.setFilled(dOMInput.getAttribute("isFilled", false));
        this.setStroked(dOMInput.getAttribute("isStroked", false));
        this.setSolid(dOMInput.getAttribute("isSolid", false));
    }

    public void write(DOMOutput dOMOutput) {
        dOMOutput.addAttribute("angle", this.angle);
        dOMOutput.addAttribute("innerRadius", this.innerRadius);
        dOMOutput.addAttribute("outerRadius", this.outerRadius);
        dOMOutput.addAttribute("isFilled", this.isFilled());
        dOMOutput.addAttribute("isStroked", this.isStroked());
        dOMOutput.addAttribute("isSolid", this.isSolid());
    }
}

