/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineDecoration;
import org.jhotdraw.draw.Liner;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.DoubleStroke;
import org.jhotdraw.geom.Insets2DDouble;

public class AttributeKeys {
    public static final AttributeKey<Color> FILL_COLOR = new AttributeKey<Color>("fillColor", Color.white);
    public static final AttributeKey<WindingRule> WINDING_RULE = new AttributeKey<WindingRule>("windingRule", WindingRule.EVEN_ODD, false);
    public static final AttributeKey<Underfill> FILL_UNDER_STROKE = new AttributeKey<Underfill>("fillUnderStroke", Underfill.CENTER, false);
    public static final AttributeKey<Color> STROKE_COLOR = new AttributeKey<Color>("strokeColor", Color.black);
    public static final AttributeKey<Double> STROKE_WIDTH = new AttributeKey<Double>("strokeWidth", 1.0, false);
    public static final AttributeKey<Double> STROKE_INNER_WIDTH_FACTOR = new AttributeKey<Double>("innerStrokeWidthFactor", 2.0, false);
    public static final AttributeKey<Integer> STROKE_JOIN = new AttributeKey<Integer>("strokeJoin", 0, false);
    public static final AttributeKey<Integer> STROKE_CAP = new AttributeKey<Integer>("strokeCap", 0, false);
    public static final AttributeKey<Double> STROKE_MITER_LIMIT_FACTOR = new AttributeKey<Double>("strokeMiterLimitFactor", 3.0, false);
    public static final AttributeKey<double[]> STROKE_DASHES = new AttributeKey<Object>("strokeDashes", null);
    public static final AttributeKey<Double> STROKE_DASH_PHASE = new AttributeKey<Double>("strokeDashPhase", 0.0, false);
    public static final AttributeKey<Double> STROKE_DASH_FACTOR = new AttributeKey<Object>("strokeDashFactor", null);
    public static final AttributeKey<StrokeType> STROKE_TYPE = new AttributeKey<StrokeType>("strokeType", StrokeType.BASIC, false);
    public static final AttributeKey<StrokePlacement> STROKE_PLACEMENT = new AttributeKey<StrokePlacement>("strokePlacement", StrokePlacement.CENTER, false);
    public static final AttributeKey<String> TEXT = new AttributeKey<Object>("text", null);
    public static final AttributeKey<Color> TEXT_COLOR = new AttributeKey<Color>("textColor", Color.black);
    public static final AttributeKey<Color> TEXT_SHADOW_COLOR = new AttributeKey<Object>("textShadowColor", null);
    public static final AttributeKey<Dimension2DDouble> TEXT_SHADOW_OFFSET = new AttributeKey<Dimension2DDouble>("textShadowOffset", new Dimension2DDouble(1.0, 1.0), false);
    public static final AttributeKey<Font> FONT_FACE = new AttributeKey<Font>("fontFace", new Font("VERDANA", 0, 10), false);
    public static final AttributeKey<Double> FONT_SIZE = new AttributeKey<Double>("fontSize", 12.0, false);
    public static final AttributeKey<Boolean> FONT_BOLD = new AttributeKey<Boolean>("fontBold", false, false);
    public static final AttributeKey<Boolean> FONT_ITALIC = new AttributeKey<Boolean>("fontItalic", false, false);
    public static final AttributeKey<Boolean> FONT_UNDERLINED = new AttributeKey<Boolean>("fontUnderlined", false, false);
    public static final AttributeKey<Liner> BEZIER_PATH_LAYOUTER = new AttributeKey<Object>("bezierPathLayouter", null);
    public static final AttributeKey<LineDecoration> END_DECORATION = new AttributeKey<Object>("endDecoration", null);
    public static final AttributeKey<LineDecoration> START_DECORATION = new AttributeKey<Object>("startDecoration", null);
    public static final AttributeKey<Insets2DDouble> DECORATOR_INSETS = new AttributeKey<Insets2DDouble>("decoratorInsets", new Insets2DDouble(0.0, 0.0, 0.0, 0.0), false);
    public static final AttributeKey<Insets2DDouble> LAYOUT_INSETS = new AttributeKey<Insets2DDouble>("borderInsets", new Insets2DDouble(0.0, 0.0, 0.0, 0.0));
    public static final AttributeKey<Orientation> ORIENTATION = new AttributeKey<Orientation>("orientation", Orientation.NORTH);
    public static final Set<AttributeKey> supportedAttributes;
    public static final Map<String, AttributeKey> supportedAttributeMap;

    public static double getStrokeTotalWidth(Figure figure) {
        switch (STROKE_TYPE.get(figure)) {
            default: {
                return STROKE_WIDTH.get(figure);
            }
            case DOUBLE: 
        }
        return STROKE_WIDTH.get(figure) * (1.0 + STROKE_INNER_WIDTH_FACTOR.get(figure));
    }

    public static Stroke getStroke(Figure figure) {
        double d = STROKE_WIDTH.get(figure);
        double d2 = STROKE_DASH_FACTOR.get(figure) != null ? STROKE_DASH_FACTOR.get(figure) : d;
        double[] dArray = STROKE_DASHES.get(figure);
        float[] fArray = null;
        if (dArray != null) {
            fArray = new float[dArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = (float)(dArray[i] * d2);
            }
        }
        switch (STROKE_TYPE.get(figure)) {
            default: {
                return new BasicStroke((float)d, 0, STROKE_JOIN.get(figure), Math.max(1.0f, (float)(STROKE_MITER_LIMIT_FACTOR.get(figure) * d)), fArray, (float)(STROKE_DASH_PHASE.get(figure) * d2));
            }
            case DOUBLE: 
        }
        return new DoubleStroke((float)(STROKE_INNER_WIDTH_FACTOR.get(figure) * d), (float)d, 0, STROKE_JOIN.get(figure), Math.max(1.0f, (float)(STROKE_MITER_LIMIT_FACTOR.get(figure) * d)), fArray, (float)((double)STROKE_DASH_PHASE.get(figure).floatValue() * d2));
    }

    public static Font getFont(Figure figure) {
        Font font = FONT_FACE.get(figure);
        if (font == null) {
            return null;
        }
        if (AttributeKeys.getFontStyle(figure) != 0) {
            return font.deriveFont(AttributeKeys.getFontStyle(figure), FONT_SIZE.get(figure).floatValue());
        }
        return font.deriveFont(FONT_SIZE.get(figure).floatValue());
    }

    public static int getFontStyle(Figure figure) {
        int n = 0;
        if (FONT_BOLD.get(figure).booleanValue()) {
            n |= 1;
        }
        if (FONT_ITALIC.get(figure).booleanValue()) {
            n |= 2;
        }
        return n;
    }

    public static double getPerpendicularFillGrowth(Figure figure) {
        double d;
        double d2 = AttributeKeys.getStrokeTotalWidth(figure);
        StrokePlacement strokePlacement = STROKE_PLACEMENT.get(figure);
        block0 : switch (FILL_UNDER_STROKE.get(figure)) {
            case FULL: {
                switch (strokePlacement) {
                    case INSIDE: {
                        d = 0.0;
                        break block0;
                    }
                    case OUTSIDE: {
                        d = d2;
                        break block0;
                    }
                }
                d = d2 / 2.0;
                break;
            }
            case NONE: {
                switch (strokePlacement) {
                    case INSIDE: {
                        d = -d2;
                        break block0;
                    }
                    case OUTSIDE: {
                        d = 0.0;
                        break block0;
                    }
                }
                d = d2 / -2.0;
                break;
            }
            default: {
                switch (strokePlacement) {
                    case INSIDE: {
                        d = d2 / -2.0;
                        break block0;
                    }
                    case OUTSIDE: {
                        d = d2 / 2.0;
                        break block0;
                    }
                }
                d = 0.0;
            }
        }
        return d;
    }

    public static double getPerpendicularDrawGrowth(Figure figure) {
        double d;
        double d2 = AttributeKeys.getStrokeTotalWidth(figure);
        StrokePlacement strokePlacement = STROKE_PLACEMENT.get(figure);
        switch (strokePlacement) {
            case INSIDE: {
                d = d2 / -2.0;
                break;
            }
            case OUTSIDE: {
                d = d2 / 2.0;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    public static double getPerpendicularHitGrowth(Figure figure) {
        double d;
        if (STROKE_COLOR.get(figure) == null) {
            d = AttributeKeys.getPerpendicularFillGrowth(figure);
        } else {
            double d2 = AttributeKeys.getStrokeTotalWidth(figure);
            d = AttributeKeys.getPerpendicularDrawGrowth(figure) + d2 / 2.0;
        }
        return d;
    }

    static {
        HashSet<AttributeKey> hashSet = new HashSet<AttributeKey>();
        hashSet.addAll(Arrays.asList(FILL_COLOR, FILL_UNDER_STROKE, STROKE_COLOR, STROKE_WIDTH, STROKE_INNER_WIDTH_FACTOR, STROKE_JOIN, STROKE_CAP, STROKE_MITER_LIMIT_FACTOR, STROKE_DASHES, STROKE_DASH_PHASE, STROKE_TYPE, STROKE_PLACEMENT, TEXT, TEXT_COLOR, TEXT_SHADOW_COLOR, TEXT_SHADOW_OFFSET, FONT_FACE, FONT_SIZE, FONT_BOLD, FONT_ITALIC, FONT_UNDERLINED, BEZIER_PATH_LAYOUTER, END_DECORATION, START_DECORATION, DECORATOR_INSETS, ORIENTATION, WINDING_RULE));
        supportedAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeKey> hashMap = new HashMap<String, AttributeKey>();
        for (AttributeKey attributeKey : hashSet) {
            hashMap.put(attributeKey.getKey(), attributeKey);
        }
        supportedAttributeMap = Collections.unmodifiableMap(hashMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        NORTH,
        NORTH_EAST,
        EAST,
        SOUTH_EAST,
        SOUTH,
        SOUTH_WEST,
        WEST,
        NORTH_WEST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StrokePlacement {
        CENTER,
        INSIDE,
        OUTSIDE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StrokeType {
        BASIC,
        DOUBLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Underfill {
        NONE,
        CENTER,
        FULL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WindingRule {
        EVEN_ODD,
        NON_ZERO;

    }
}

