/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.geom.BezierPath;

class BezierNodeEdit
extends AbstractUndoableEdit {
    private BezierFigure owner;
    private int index;
    private BezierPath.Node oldValue;
    private BezierPath.Node newValue;

    public BezierNodeEdit(BezierFigure bezierFigure, int n, BezierPath.Node node, BezierPath.Node node2) {
        this.owner = bezierFigure;
        this.index = n;
        this.oldValue = node;
        this.newValue = node2;
    }

    public String getPresentationName() {
        return "Punkt verschieben";
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.owner.willChange();
        this.owner.basicSetNode(this.index, this.newValue);
        this.owner.changed();
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.owner.willChange();
        this.owner.basicSetNode(this.index, this.oldValue);
        this.owner.changed();
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof BezierNodeEdit) {
            BezierNodeEdit bezierNodeEdit = (BezierNodeEdit)undoableEdit;
            if (bezierNodeEdit.owner == this.owner && bezierNodeEdit.index == this.index) {
                this.newValue = bezierNodeEdit.newValue;
                bezierNodeEdit.die();
                return true;
            }
        }
        return false;
    }

    public boolean replaceEdit(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof BezierNodeEdit) {
            BezierNodeEdit bezierNodeEdit = (BezierNodeEdit)undoableEdit;
            if (bezierNodeEdit.owner == this.owner && bezierNodeEdit.index == this.index) {
                bezierNodeEdit.oldValue = this.oldValue;
                this.die();
                return true;
            }
        }
        return false;
    }
}

