/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ChopBoxConnector;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Geom;

public class ChopEllipseConnector
extends ChopBoxConnector {
    public ChopEllipseConnector() {
    }

    public ChopEllipseConnector(Figure figure) {
        super(figure);
    }

    private Color getStrokeColor(Figure figure) {
        return (Color)figure.getAttribute(AttributeKeys.STROKE_COLOR);
    }

    private float getStrokeWidth(Figure figure) {
        Float f = (Float)figure.getAttribute(AttributeKeys.STROKE_WIDTH);
        return f == null ? 1.0f : f.floatValue();
    }

    protected Point2D.Double chop(Figure figure, Point2D.Double double_) {
        double d;
        figure = this.getConnectorTarget(figure);
        Rectangle2D.Double double_2 = figure.getBounds();
        if (this.getStrokeColor(figure) != null) {
            switch (AttributeKeys.STROKE_PLACEMENT.get(figure)) {
                default: {
                    d = AttributeKeys.getStrokeTotalWidth(figure) / 2.0;
                    break;
                }
                case OUTSIDE: {
                    d = AttributeKeys.getStrokeTotalWidth(figure);
                    break;
                }
                case INSIDE: {
                    d = 0.0;
                }
            }
            Geom.grow(double_2, d, d);
        }
        d = Geom.pointToAngle(double_2, double_);
        return Geom.ovalAngleToPoint(double_2, d);
    }
}

