/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDrawingEditor
extends AbstractBean
implements DrawingEditor,
ToolListener {
    private HashMap<AttributeKey, Object> defaultAttributes = new HashMap();
    private Tool tool;
    private HashSet<DrawingView> views;
    private DrawingView activeView;
    private boolean isEnabled = true;
    private DrawingView focusedView;
    private FocusListener focusHandler = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            DefaultDrawingEditor.this.setFocusedView(DefaultDrawingEditor.this.findView((Container)focusEvent.getSource()));
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                DefaultDrawingEditor.this.setFocusedView(null);
            }
        }
    };

    public DefaultDrawingEditor() {
        this.setDefaultAttribute(AttributeKeys.FILL_COLOR, Color.white);
        this.setDefaultAttribute(AttributeKeys.STROKE_COLOR, Color.black);
        this.setDefaultAttribute(AttributeKeys.TEXT_COLOR, Color.black);
        this.views = new HashSet();
    }

    @Override
    public void setTool(Tool tool) {
        if (tool == this.tool) {
            return;
        }
        if (this.tool != null) {
            for (DrawingView drawingView : this.views) {
                drawingView.removeMouseListener(this.tool);
                drawingView.removeMouseMotionListener(this.tool);
                drawingView.removeKeyListener(this.tool);
            }
            this.tool.deactivate(this);
            this.tool.removeToolListener(this);
        }
        this.tool = tool;
        if (this.tool != null) {
            this.tool.activate(this);
            for (DrawingView drawingView : this.views) {
                drawingView.addMouseListener(this.tool);
                drawingView.addMouseMotionListener(this.tool);
                drawingView.addKeyListener(this.tool);
            }
            this.tool.addToolListener(this);
        }
    }

    @Override
    public void areaInvalidated(ToolEvent toolEvent) {
        Rectangle rectangle = toolEvent.getInvalidatedArea();
        toolEvent.getView().getContainer().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void toolStarted(ToolEvent toolEvent) {
        this.setView(toolEvent.getView());
    }

    @Override
    public void setView(DrawingView drawingView) {
        DrawingView drawingView2 = this.activeView;
        this.activeView = drawingView;
        this.firePropertyChange("view", drawingView2, drawingView);
        for (DrawingView drawingView3 : this.views) {
            drawingView3.getContainer().repaint();
        }
    }

    @Override
    public void toolDone(ToolEvent toolEvent) {
        DrawingView drawingView = this.getView();
        if (drawingView != null) {
            Container container = drawingView.getContainer();
            container.invalidate();
            if (container.getParent() != null) {
                container.getParent().validate();
            }
        }
    }

    @Override
    public Tool getTool() {
        return this.tool;
    }

    @Override
    public DrawingView getView() {
        return this.activeView != null ? this.activeView : this.views.iterator().next();
    }

    private void updateFocusedView() {
        for (DrawingView drawingView : this.views) {
            if (!drawingView.getContainer().hasFocus()) continue;
            this.setFocusedView(drawingView);
            return;
        }
        this.setFocusedView(null);
    }

    private void setFocusedView(DrawingView drawingView) {
        DrawingView drawingView2 = this.focusedView;
        this.focusedView = drawingView;
        this.firePropertyChange("focusedView", drawingView2, drawingView);
    }

    @Override
    public DrawingView getFocusedView() {
        return this.focusedView;
    }

    @Override
    public void applyDefaultAttributesTo(Figure figure) {
        for (Map.Entry<AttributeKey, Object> entry : this.defaultAttributes.entrySet()) {
            figure.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object getDefaultAttribute(AttributeKey attributeKey) {
        return this.defaultAttributes.get(attributeKey);
    }

    @Override
    public void setDefaultAttribute(AttributeKey attributeKey, Object object) {
        Object object2 = this.defaultAttributes.put(attributeKey, object);
        this.firePropertyChange(attributeKey.getKey(), object2, object);
    }

    @Override
    public void remove(DrawingView drawingView) {
        drawingView.getContainer().removeFocusListener(this.focusHandler);
        this.views.remove(drawingView);
        if (this.tool != null) {
            drawingView.removeMouseListener(this.tool);
            drawingView.removeMouseMotionListener(this.tool);
            drawingView.removeKeyListener(this.tool);
        }
        drawingView.removeNotify(this);
        if (this.activeView == drawingView) {
            drawingView = this.views.size() > 0 ? this.views.iterator().next() : null;
        }
        this.updateFocusedView();
    }

    @Override
    public void add(DrawingView drawingView) {
        this.views.add(drawingView);
        drawingView.addNotify(this);
        drawingView.getContainer().addFocusListener(this.focusHandler);
        if (this.tool != null) {
            drawingView.addMouseListener(this.tool);
            drawingView.addMouseMotionListener(this.tool);
            drawingView.addKeyListener(this.tool);
        }
        this.updateFocusedView();
    }

    @Override
    public void setCursor(Cursor cursor) {
    }

    @Override
    public Collection<DrawingView> getDrawingViews() {
        return Collections.unmodifiableCollection(this.views);
    }

    @Override
    public DrawingView findView(Container container) {
        for (DrawingView drawingView : this.views) {
            if (drawingView.getContainer() != container) continue;
            return drawingView;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled) {
            boolean bl2 = this.isEnabled;
            this.isEnabled = bl;
            this.firePropertyChange("enabled", bl2, bl);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }
}

