/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.AttributedFigure;
import org.jhotdraw.draw.ChopEllipseConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.geom.Geom;

public class EllipseFigure
extends AttributedFigure {
    private Ellipse2D.Double ellipse;

    public EllipseFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public EllipseFigure(double d, double d2, double d3, double d4) {
        this.ellipse = new Ellipse2D.Double(d, d2, d3, d4);
        this.setAttributeEnabled(AttributeKeys.TEXT_COLOR, false);
    }

    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return new ChopEllipseConnector(this);
    }

    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return new ChopEllipseConnector(this);
    }

    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.ellipse.getBounds2D();
    }

    public Rectangle2D.Double getFigureDrawBounds() {
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.ellipse.getBounds2D();
        double d = AttributeKeys.getPerpendicularHitGrowth(this);
        Geom.grow(double_, d, d);
        return double_;
    }

    protected void drawFill(Graphics2D graphics2D) {
        Ellipse2D.Double double_ = (Ellipse2D.Double)this.ellipse.clone();
        double d = AttributeKeys.getPerpendicularFillGrowth(this);
        double_.x -= d;
        double_.y -= d;
        double_.width += d * 2.0;
        double_.height += d * 2.0;
        if (double_.width > 0.0 && double_.height > 0.0) {
            graphics2D.fill(double_);
        }
    }

    protected void drawStroke(Graphics2D graphics2D) {
        Ellipse2D.Double double_ = (Ellipse2D.Double)this.ellipse.clone();
        double d = AttributeKeys.getPerpendicularDrawGrowth(this);
        double_.x -= d;
        double_.y -= d;
        double_.width += d * 2.0;
        double_.height += d * 2.0;
        if (double_.width > 0.0 && double_.height > 0.0) {
            graphics2D.draw(double_);
        }
    }

    public boolean contains(Point2D.Double double_) {
        Ellipse2D.Double double_2 = (Ellipse2D.Double)this.ellipse.clone();
        double d = AttributeKeys.getPerpendicularHitGrowth(this);
        double_2.x -= d;
        double_2.y -= d;
        double_2.width += d * 2.0;
        double_2.height += d * 2.0;
        return double_2.contains(double_);
    }

    public void basicSetBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.ellipse.x = Math.min(double_.x, double_2.x);
        this.ellipse.y = Math.min(double_.y, double_2.y);
        this.ellipse.width = Math.max(0.1, Math.abs(double_2.x - double_.x));
        this.ellipse.height = Math.max(0.1, Math.abs(double_2.y - double_.y));
    }

    public void basicTransform(AffineTransform affineTransform) {
        Point2D.Double double_ = this.getStartPoint();
        Point2D.Double double_2 = this.getEndPoint();
        this.basicSetBounds((Point2D.Double)affineTransform.transform(double_, double_), (Point2D.Double)affineTransform.transform(double_2, double_2));
    }

    public EllipseFigure clone() {
        EllipseFigure ellipseFigure = (EllipseFigure)super.clone();
        ellipseFigure.ellipse = (Ellipse2D.Double)this.ellipse.clone();
        return ellipseFigure;
    }

    public void restoreTo(Object object) {
        Ellipse2D.Double double_ = (Ellipse2D.Double)object;
        this.ellipse.x = double_.x;
        this.ellipse.y = double_.y;
        this.ellipse.width = double_.width;
        this.ellipse.height = double_.height;
    }

    public Object getRestoreData() {
        return this.ellipse.clone();
    }
}

