/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.TextHolder;

public class FloatingTextField {
    private JTextField editWidget = new JTextField(20);
    private DrawingView view;

    public void createOverlay(DrawingView drawingView) {
        this.createOverlay(drawingView, null);
    }

    public void requestFocus() {
        this.editWidget.requestFocus();
    }

    public void createOverlay(DrawingView drawingView, TextHolder textHolder) {
        drawingView.getContainer().add((Component)this.editWidget, 0);
        Font font = textHolder.getFont();
        font = font.deriveFont(font.getStyle(), (float)((double)font.getSize() * drawingView.getScaleFactor()));
        this.editWidget.setFont(font);
        this.editWidget.setForeground(textHolder.getTextColor());
        this.editWidget.setBackground(textHolder.getFillColor());
        this.view = drawingView;
    }

    public Insets getInsets() {
        return this.editWidget.getInsets();
    }

    public void addActionListener(ActionListener actionListener) {
        this.editWidget.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.editWidget.removeActionListener(actionListener);
    }

    public void setBounds(Rectangle rectangle, String string) {
        this.editWidget.setText(string);
        this.editWidget.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.editWidget.setVisible(true);
        this.editWidget.selectAll();
        this.editWidget.requestFocus();
    }

    public String getText() {
        return this.editWidget.getText();
    }

    public Dimension getPreferredSize(int n) {
        this.editWidget.setColumns(n);
        return this.editWidget.getPreferredSize();
    }

    public void endOverlay() {
        this.view.getContainer().requestFocus();
        if (this.editWidget != null) {
            this.editWidget.setVisible(false);
            this.view.getContainer().remove(this.editWidget);
            Rectangle rectangle = this.editWidget.getBounds();
            this.view.getContainer().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

