/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierNodeHandle;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.geom.BezierPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineFigure
extends BezierFigure {
    public LineFigure() {
        this.basicAddNode(new BezierPath.Node(new Point2D.Double(0.0, 0.0)));
        this.basicAddNode(new BezierPath.Node(new Point2D.Double(0.0, 0.0)));
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        switch (n) {
            case 0: {
                int n2 = this.path.size();
                for (int i = 0; i < n2; ++i) {
                    linkedList.add(new BezierNodeHandle(this, i));
                }
                break;
            }
        }
        return linkedList;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double double_, MouseEvent mouseEvent, DrawingView drawingView) {
        if (mouseEvent.getClickCount() == 2 && drawingView.getHandleDetailLevel() == 0) {
            this.willChange();
            final int n = this.basicSplitSegment(double_, (float)(5.0 / drawingView.getScaleFactor()));
            if (n != -1) {
                final BezierPath.Node node = this.getNode(n);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    public void redo() throws CannotRedoException {
                        super.redo();
                        LineFigure.this.willChange();
                        LineFigure.this.basicAddNode(n, node);
                        LineFigure.this.changed();
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        LineFigure.this.willChange();
                        LineFigure.this.basicRemoveNode(n);
                        LineFigure.this.changed();
                    }
                });
                this.changed();
                return true;
            }
        }
        return false;
    }
}

