/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.RestoreDataEdit;
import org.jhotdraw.geom.Geom;

public class RotateHandle
extends AbstractHandle {
    private Point location;
    private Object restoreData;
    private AffineTransform transform;
    private Point2D.Double center;
    private double startTheta;
    private double startLength;

    public RotateHandle(Figure figure) {
        super(figure);
    }

    public boolean isCombinableWith(Handle handle) {
        return false;
    }

    public void draw(Graphics2D graphics2D) {
        this.drawDiamond(graphics2D, Color.green, Color.black);
    }

    protected Rectangle basicGetBounds() {
        Rectangle rectangle = new Rectangle(this.getLocation());
        rectangle.grow(this.getHandlesize() / 2, this.getHandlesize() / 2);
        return rectangle;
    }

    public Point getLocation() {
        if (this.location == null) {
            return this.view.drawingToView(this.getOrigin());
        }
        return this.location;
    }

    private Point2D.Double getOrigin() {
        Rectangle2D.Double double_ = this.getOwner().getBounds();
        return new Point2D.Double(double_.getCenterX(), double_.y - (double)this.getHandlesize());
    }

    public void trackStart(Point point, int n) {
        this.location = new Point(point.x, point.y);
        this.restoreData = this.getOwner().getRestoreData();
        Rectangle2D.Double double_ = this.getOwner().getBounds();
        this.transform = new AffineTransform();
        this.center = new Point2D.Double(double_.getCenterX(), double_.getCenterY());
        Point2D.Double double_2 = this.view.viewToDrawing(point);
        this.startTheta = Geom.angle(this.center.x, this.center.y, double_2.x, double_2.y);
        this.startLength = Geom.length(this.center.x, this.center.y, double_2.x, double_2.y);
    }

    public void trackStep(Point point, Point point2, int n) {
        this.location = new Point(point2.x, point2.y);
        Point2D.Double double_ = this.view.viewToDrawing(point2);
        double d = Geom.angle(this.center.x, this.center.y, double_.x, double_.y);
        double d2 = Geom.length(this.center.x, this.center.y, double_.x, double_.y);
        this.transform.setToIdentity();
        this.transform.translate(this.center.x, this.center.y);
        this.transform.rotate(d - this.startTheta);
        this.transform.translate(-this.center.x, -this.center.y);
        this.getOwner().willChange();
        this.getOwner().restoreTo(this.restoreData);
        this.getOwner().basicTransform(this.transform);
        this.getOwner().changed();
    }

    public void trackEnd(Point point, Point point2, int n) {
        this.view.getDrawing().fireUndoableEditHappened(new RestoreDataEdit(this.getOwner(), this.restoreData));
        this.location = null;
    }
}

