/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.RoundRectangleFigure;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.undo.CompositeEdit;

public class RoundRectRadiusHandle
extends AbstractHandle {
    private static final int OFFSET = 6;
    private Point originalArc;
    CompositeEdit edit;

    public RoundRectRadiusHandle(Figure figure) {
        super(figure);
    }

    public void draw(Graphics2D graphics2D) {
        this.drawDiamond(graphics2D, Color.yellow, Color.black);
    }

    protected Rectangle basicGetBounds() {
        Rectangle rectangle = new Rectangle(this.locate());
        rectangle.grow(this.getHandlesize() / 2 + 1, this.getHandlesize() / 2 + 1);
        return rectangle;
    }

    private Point locate() {
        RoundRectangleFigure roundRectangleFigure = (RoundRectangleFigure)this.getOwner();
        Rectangle rectangle = this.view.drawingToView(roundRectangleFigure.getBounds());
        Point point = this.view.drawingToView(new Point2D.Double(roundRectangleFigure.getArcWidth(), roundRectangleFigure.getArcHeight()));
        return new Point(rectangle.x + point.x / 2 + 6, rectangle.y + point.y / 2 + 6);
    }

    public void trackStart(Point point, int n) {
        this.edit = new CompositeEdit("Mehrfachaenderung");
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
        RoundRectangleFigure roundRectangleFigure = (RoundRectangleFigure)this.getOwner();
        this.originalArc = this.view.drawingToView(new Point2D.Double(roundRectangleFigure.getArcWidth(), roundRectangleFigure.getArcHeight()));
    }

    public void trackStep(Point point, Point point2, int n) {
        int n2 = point2.x - point.x;
        int n3 = point2.y - point.y;
        RoundRectangleFigure roundRectangleFigure = (RoundRectangleFigure)this.getOwner();
        Rectangle rectangle = this.view.drawingToView(roundRectangleFigure.getBounds());
        Point point3 = new Point(Geom.range(0, rectangle.width, 2 * (this.originalArc.x / 2 + n2)), Geom.range(0, rectangle.height, 2 * (this.originalArc.y / 2 + n3)));
        Point2D.Double double_ = this.view.viewToDrawing(point3);
        roundRectangleFigure.setArc(double_.x, double_.y);
    }

    public void trackEnd(Point point, Point point2, int n) {
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
    }
}

