/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.AttributedFigure;
import org.jhotdraw.draw.ChopRoundRectConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.RoundRectRadiusHandle;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRectangleFigure
extends AttributedFigure {
    private RoundRectangle2D.Double roundrect;
    private static final double DEFAULT_ARC = 20.0;

    public RoundRectangleFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public RoundRectangleFigure(double d, double d2, double d3, double d4) {
        this.roundrect = new RoundRectangle2D.Double(d, d2, d3, d4, 20.0, 20.0);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.roundrect.getBounds2D();
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.roundrect.getBounds2D();
        double d = AttributeKeys.getPerpendicularHitGrowth(this);
        Geom.grow(double_, d, d);
        return double_;
    }

    public double getArcWidth() {
        return this.roundrect.arcwidth;
    }

    public double getArcHeight() {
        return this.roundrect.archeight;
    }

    public void setArc(final double d, final double d2) {
        final double d3 = this.roundrect.getArcWidth();
        final double d4 = this.roundrect.getArcHeight();
        this.roundrect.arcwidth = d;
        this.roundrect.archeight = d2;
        this.fireFigureChanged(this.getDrawBounds());
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            public String getPresentationName() {
                return "Rundung";
            }

            public void undo() throws CannotUndoException {
                super.undo();
                RoundRectangleFigure.this.willChange();
                ((RoundRectangleFigure)RoundRectangleFigure.this).roundrect.arcwidth = d3;
                ((RoundRectangleFigure)RoundRectangleFigure.this).roundrect.archeight = d4;
                RoundRectangleFigure.this.changed();
            }

            public void redo() throws CannotRedoException {
                super.redo();
                RoundRectangleFigure.this.willChange();
                ((RoundRectangleFigure)RoundRectangleFigure.this).roundrect.arcwidth = d;
                ((RoundRectangleFigure)RoundRectangleFigure.this).roundrect.archeight = d2;
                RoundRectangleFigure.this.changed();
            }
        });
    }

    @Override
    protected void drawFill(Graphics2D graphics2D) {
        RoundRectangle2D.Double double_ = (RoundRectangle2D.Double)this.roundrect.clone();
        double d = AttributeKeys.getPerpendicularFillGrowth(this);
        double_.x -= d;
        double_.y -= d;
        double_.width += d * 2.0;
        double_.height += d * 2.0;
        double_.arcwidth += d * 2.0;
        double_.archeight += d * 2.0;
        if (double_.width > 0.0 && double_.height > 0.0) {
            graphics2D.fill(double_);
        }
    }

    @Override
    protected void drawStroke(Graphics2D graphics2D) {
        RoundRectangle2D.Double double_ = (RoundRectangle2D.Double)this.roundrect.clone();
        double d = AttributeKeys.getPerpendicularDrawGrowth(this);
        double_.x -= d;
        double_.y -= d;
        double_.width += d * 2.0;
        double_.height += d * 2.0;
        double_.arcwidth += d * 2.0;
        double_.archeight += d * 2.0;
        if (double_.width > 0.0 && double_.height > 0.0) {
            graphics2D.draw(double_);
        }
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        RoundRectangle2D.Double double_2 = (RoundRectangle2D.Double)this.roundrect.clone();
        double d = AttributeKeys.getPerpendicularHitGrowth(this);
        double_2.x -= d;
        double_2.y -= d;
        double_2.width += d * 2.0;
        double_2.height += d * 2.0;
        double_2.arcwidth += d * 2.0;
        double_2.archeight += d * 2.0;
        return double_2.contains(double_);
    }

    @Override
    public void basicSetBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.roundrect.x = Math.min(double_.x, double_2.x);
        this.roundrect.y = Math.min(double_.y, double_2.y);
        this.roundrect.width = Math.max(0.1, Math.abs(double_2.x - double_.x));
        this.roundrect.height = Math.max(0.1, Math.abs(double_2.y - double_.y));
    }

    @Override
    public void basicTransform(AffineTransform affineTransform) {
        Point2D.Double double_ = this.getStartPoint();
        Point2D.Double double_2 = this.getEndPoint();
        this.basicSetBounds((Point2D.Double)affineTransform.transform(double_, double_), (Point2D.Double)affineTransform.transform(double_2, double_2));
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList linkedList = (LinkedList)super.createHandles(n);
        linkedList.add(new RoundRectRadiusHandle(this));
        return linkedList;
    }

    @Override
    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return new ChopRoundRectConnector(this);
    }

    @Override
    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return new ChopRoundRectConnector(this);
    }

    @Override
    public RoundRectangleFigure clone() {
        RoundRectangleFigure roundRectangleFigure = (RoundRectangleFigure)super.clone();
        roundRectangleFigure.roundrect = (RoundRectangle2D.Double)this.roundrect.clone();
        return roundRectangleFigure;
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        super.read(dOMInput);
        this.roundrect.arcwidth = dOMInput.getAttribute("arcWidth", 20.0);
        this.roundrect.archeight = dOMInput.getAttribute("arcHeight", 20.0);
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        super.write(dOMOutput);
        dOMOutput.addAttribute("arcWidth", this.roundrect.arcwidth);
        dOMOutput.addAttribute("arcHeight", this.roundrect.archeight);
    }

    @Override
    public void restoreTo(Object object) {
        RoundRectangle2D.Double double_ = (RoundRectangle2D.Double)object;
        this.roundrect.x = double_.x;
        this.roundrect.y = double_.y;
        this.roundrect.width = double_.width;
        this.roundrect.height = double_.height;
    }

    @Override
    public Object getRestoreData() {
        return this.roundrect.clone();
    }

    public Point2D.Double chop(Point2D.Double double_) {
        double d;
        Rectangle2D.Double double_2 = this.getBounds();
        switch (AttributeKeys.STROKE_PLACEMENT.get(this)) {
            default: {
                d = AttributeKeys.getStrokeTotalWidth(this) / 2.0;
                break;
            }
            case OUTSIDE: {
                d = AttributeKeys.getStrokeTotalWidth(this);
                break;
            }
            case INSIDE: {
                d = 0.0;
            }
        }
        double_2.x -= d;
        double_2.y -= d;
        double_2.width += d * 2.0;
        double_2.height += d * 2.0;
        Rectangle2D.Double double_3 = (Rectangle2D.Double)double_2.clone();
        double d2 = -(this.getArcWidth() + d * 2.0) / 2.0;
        double d3 = -(this.getArcHeight() + d * 2.0) / 2.0;
        double_3.x -= d2;
        double_3.y -= d3;
        double_3.width += d2 * 2.0;
        double_3.height += d3 * 2.0;
        double d4 = Geom.pointToAngle(double_2, double_);
        Point2D.Double double_4 = Geom.angleToPoint(double_2, Geom.pointToAngle(double_2, double_));
        if (double_4.x == double_2.x || double_4.x == double_2.x + double_2.width) {
            double_4.y = Math.min(Math.max(double_4.y, double_3.y), double_3.y + double_3.height);
        } else {
            double_4.x = Math.min(Math.max(double_4.x, double_3.x), double_3.x + double_3.width);
        }
        return double_4;
    }
}

