/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractSelectedAction
extends AbstractAction {
    private DrawingEditor editor;
    protected ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
    private PropertyChangeListener propertyChangeHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                AbstractSelectedAction.this.updateEnabledState();
            }
        }
    };
    private EventHandler eventHandler = new EventHandler();

    public AbstractSelectedAction(DrawingEditor drawingEditor) {
        this.setEditor(drawingEditor);
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled() && this.getView().getSelectionCount() > 0);
        } else {
            this.setEnabled(false);
        }
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.eventHandler);
            if (this.editor.getView() != null) {
                this.editor.getView().removeFigureSelectionListener(this.eventHandler);
            }
        }
        this.editor = null;
    }

    public void setEditor(DrawingEditor drawingEditor) {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.eventHandler);
            if (this.getView() != null) {
                this.getView().removeFigureSelectionListener(this.eventHandler);
            }
        }
        this.editor = drawingEditor;
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(this.eventHandler);
        }
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    protected DrawingView getView() {
        return this.editor == null ? null : this.editor.getFocusedView();
    }

    protected Drawing getDrawing() {
        return this.getView() == null ? null : this.getView().getDrawing();
    }

    protected void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        this.getDrawing().fireUndoableEditHappened(undoableEdit);
    }

    private class EventHandler
    implements PropertyChangeListener,
    FigureSelectionListener {
        private EventHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("focusedView")) {
                DrawingView drawingView;
                if (propertyChangeEvent.getOldValue() != null) {
                    drawingView = (DrawingView)propertyChangeEvent.getOldValue();
                    drawingView.removeFigureSelectionListener(this);
                    drawingView.removePropertyChangeListener(AbstractSelectedAction.this.propertyChangeHandler);
                }
                if (propertyChangeEvent.getNewValue() != null) {
                    drawingView = (DrawingView)propertyChangeEvent.getNewValue();
                    drawingView.addFigureSelectionListener(this);
                    drawingView.addPropertyChangeListener(AbstractSelectedAction.this.propertyChangeHandler);
                }
                AbstractSelectedAction.this.updateEnabledState();
            }
        }

        public void selectionChanged(FigureSelectionEvent figureSelectionEvent) {
            AbstractSelectedAction.this.updateEnabledState();
        }
    }
}

