/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractViewAction
extends AbstractAction {
    private DrawingEditor editor;
    private DrawingView view;
    protected static final ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
    private PropertyChangeListener propertyChangeHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                AbstractViewAction.this.updateEnabledState();
            }
        }
    };

    public AbstractViewAction(DrawingEditor drawingEditor) {
        this.editor = drawingEditor;
        drawingEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("view")) {
                    DrawingView drawingView;
                    if (propertyChangeEvent.getOldValue() != null) {
                        drawingView = (DrawingView)propertyChangeEvent.getOldValue();
                        drawingView.removePropertyChangeListener(AbstractViewAction.this.propertyChangeHandler);
                    }
                    if (propertyChangeEvent.getNewValue() != null) {
                        drawingView = (DrawingView)propertyChangeEvent.getOldValue();
                        drawingView.addPropertyChangeListener(AbstractViewAction.this.propertyChangeHandler);
                        AbstractViewAction.this.updateEnabledState();
                    }
                }
            }
        });
    }

    public AbstractViewAction(DrawingView drawingView) {
        this.view = drawingView;
    }

    protected void setEditor(DrawingEditor drawingEditor) {
        this.editor = drawingEditor;
    }

    protected DrawingView getView() {
        return this.view != null ? this.view : this.editor.getView();
    }

    protected Drawing getDrawing() {
        return this.getView().getDrawing();
    }

    protected void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        this.getDrawing().fireUndoableEditHappened(undoableEdit);
    }

    protected void viewChanged() {
    }

    public void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled() && this.getView().getSelectionCount() > 0);
        } else {
            this.setEnabled(false);
        }
    }
}

