/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;

public class ColorChooserAction
extends AbstractSelectedAction {
    private AttributeKey key;
    private static JColorChooser colorChooser;

    public ColorChooserAction(DrawingEditor drawingEditor, AttributeKey attributeKey) {
        this(drawingEditor, attributeKey, null, null);
    }

    public ColorChooserAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Icon icon) {
        this(drawingEditor, attributeKey, null, icon);
    }

    public ColorChooserAction(DrawingEditor drawingEditor, AttributeKey attributeKey, String string) {
        this(drawingEditor, attributeKey, string, null);
    }

    public ColorChooserAction(DrawingEditor drawingEditor, AttributeKey attributeKey, String string, Icon icon) {
        super(drawingEditor);
        this.key = attributeKey;
        this.putValue("Name", string);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        Color color2;
        if (colorChooser == null) {
            colorChooser = new JColorChooser();
        }
        if ((color2 = (Color)this.getEditor().getDefaultAttribute(this.key)) == null) {
            color2 = Color.red;
        }
        if ((color = JColorChooser.showDialog((Component)actionEvent.getSource(), this.labels.getString("drawColor"), color2)) != null) {
            this.changeAttribute(color);
        }
    }

    public void changeAttribute(Color color) {
        Drawing drawing = this.getDrawing();
        for (Figure figure : this.getView().getSelectedFigures()) {
            figure.setAttribute(this.key, color);
        }
        this.getEditor().setDefaultAttribute(this.key, color);
    }

    public void selectionChanged(FigureSelectionEvent figureSelectionEvent) {
    }
}

