/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.MoveToFrontAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class MoveToBackAction
extends AbstractSelectedAction {
    private ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());

    public MoveToBackAction(DrawingEditor drawingEditor) {
        super(drawingEditor);
        this.labels.configureAction(this, "moveToBack");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final DrawingView drawingView = this.getView();
        final LinkedList<Figure> linkedList = new LinkedList<Figure>(drawingView.getSelectedFigures());
        MoveToBackAction.sendToBack(drawingView, linkedList);
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            public String getPresentationName() {
                return MoveToBackAction.this.labels.getString("moveToBack");
            }

            public void redo() throws CannotRedoException {
                super.redo();
                MoveToBackAction.sendToBack(drawingView, linkedList);
            }

            public void undo() throws CannotUndoException {
                super.undo();
                MoveToFrontAction.bringToFront(drawingView, linkedList);
            }
        });
    }

    public static void sendToBack(DrawingView drawingView, Collection collection) {
        Iterator iterator = collection.iterator();
        Drawing drawing = drawingView.getDrawing();
        while (iterator.hasNext()) {
            Figure figure = (Figure)iterator.next();
            drawing.sendToBack(figure);
        }
    }
}

