/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.MoveToBackAction;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveToFrontAction
extends AbstractSelectedAction {
    private ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());

    public MoveToFrontAction(DrawingEditor drawingEditor) {
        super(drawingEditor);
        this.labels.configureAction(this, "moveToFront");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final DrawingView drawingView = this.getView();
        final LinkedList<Figure> linkedList = new LinkedList<Figure>(drawingView.getSelectedFigures());
        MoveToFrontAction.bringToFront(drawingView, linkedList);
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            public String getPresentationName() {
                return MoveToFrontAction.this.labels.getString("moveToFront");
            }

            public void redo() throws CannotRedoException {
                super.redo();
                MoveToFrontAction.bringToFront(drawingView, linkedList);
            }

            public void undo() throws CannotUndoException {
                super.undo();
                MoveToBackAction.sendToBack(drawingView, linkedList);
            }
        });
    }

    public static void bringToFront(DrawingView drawingView, Collection<Figure> collection) {
        Drawing drawing = drawingView.getDrawing();
        for (Figure figure : drawing.sort(collection)) {
            drawing.bringToFront(figure);
        }
    }
}

