/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.undo.CompositeEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UngroupAction
extends AbstractSelectedAction {
    public static final String ID = "selectionUngroup";
    private CompositeFigure prototype;

    public UngroupAction(DrawingEditor drawingEditor) {
        this(drawingEditor, new GroupFigure());
    }

    public UngroupAction(DrawingEditor drawingEditor, CompositeFigure compositeFigure) {
        super(drawingEditor);
        this.prototype = compositeFigure;
        this.labels.configureAction(this, ID);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.canUngroup());
        } else {
            this.setEnabled(false);
        }
    }

    protected boolean canUngroup() {
        return this.getView().getSelectionCount() == 1 && this.getView().getSelectedFigures().iterator().next().getClass().equals(this.prototype.getClass());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.canUngroup()) {
            final DrawingView drawingView = this.getView();
            final CompositeFigure compositeFigure = (CompositeFigure)this.getView().getSelectedFigures().iterator().next();
            final LinkedList<Figure> linkedList = new LinkedList<Figure>();
            CompositeEdit compositeEdit = new CompositeEdit(this.labels.getString(ID)){

                public void redo() throws CannotRedoException {
                    super.redo();
                    UngroupAction.this.ungroupFigures(drawingView, compositeFigure);
                }

                public void undo() throws CannotUndoException {
                    UngroupAction.this.groupFigures(drawingView, compositeFigure, linkedList);
                    super.undo();
                }
            };
            this.fireUndoableEditHappened(compositeEdit);
            linkedList.addAll(this.ungroupFigures(drawingView, compositeFigure));
            this.fireUndoableEditHappened(compositeEdit);
        }
    }

    public Collection<Figure> ungroupFigures(DrawingView drawingView, CompositeFigure compositeFigure) {
        LinkedList<Figure> linkedList = new LinkedList<Figure>(compositeFigure.getChildren());
        drawingView.clearSelection();
        compositeFigure.basicRemoveAllChildren();
        drawingView.getDrawing().basicAddAll(linkedList);
        drawingView.getDrawing().remove(compositeFigure);
        drawingView.addToSelection(linkedList);
        return linkedList;
    }

    public void groupFigures(DrawingView drawingView, CompositeFigure compositeFigure, Collection<Figure> collection) {
        Collection<Figure> collection2 = drawingView.getDrawing().sort(collection);
        drawingView.getDrawing().basicRemoveAll(collection);
        drawingView.clearSelection();
        drawingView.getDrawing().add(compositeFigure);
        compositeFigure.willChange();
        for (Figure figure : collection2) {
            compositeFigure.basicAdd(figure);
        }
        compositeFigure.changed();
        drawingView.addToSelection(compositeFigure);
    }
}

