/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class CompositeTransferable
implements Transferable,
ClipboardOwner {
    private HashMap transferables = new HashMap();
    private LinkedList flavors = new LinkedList();

    public void add(Transferable transferable) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!this.transferables.containsKey(dataFlavorArray[i])) {
                this.flavors.add(dataFlavorArray[i]);
            }
            this.transferables.put(dataFlavorArray[i], transferable);
        }
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        Transferable transferable = (Transferable)this.transferables.get(dataFlavor);
        if (transferable == null) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return transferable.getTransferData(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors.toArray(new DataFlavor[this.transferables.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.transferables.containsKey(dataFlavor);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

