/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierTool;
import org.jhotdraw.samples.svg.figures.SVGPath;

public class PathTool
extends BezierTool {
    private SVGPath pathPrototype;

    public PathTool(SVGPath sVGPath, BezierFigure bezierFigure) {
        this(sVGPath, bezierFigure, null);
    }

    public PathTool(SVGPath sVGPath, BezierFigure bezierFigure, Map map) {
        super(bezierFigure, map);
        this.pathPrototype = sVGPath;
    }

    protected SVGPath createPath() {
        SVGPath sVGPath = (SVGPath)this.pathPrototype.clone();
        this.getEditor().applyDefaultAttributesTo(sVGPath);
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                sVGPath.setAttribute((AttributeKey)entry.getKey(), entry.getValue());
            }
        }
        return sVGPath;
    }

    protected void finishCreation(BezierFigure bezierFigure) {
        this.getDrawing().remove(bezierFigure);
        SVGPath sVGPath = this.createPath();
        sVGPath.removeAllChildren();
        sVGPath.add(bezierFigure);
        this.getDrawing().add(sVGPath);
        this.getView().addToSelection(sVGPath);
    }
}

