/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.io.IOException;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.samples.svg.figures.SVGGroup;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class SVGDrawing
extends DefaultDrawing {
    private String title;
    private String description;

    public void setTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.firePropertyChange("title", string2, string);
    }

    public String getTitle() {
        return this.title;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        this.firePropertyChange("description", string2, string);
    }

    public String getDescription() {
        return this.description;
    }

    public void read(DOMInput dOMInput) throws IOException {
        int n = dOMInput.getElementCount();
        for (int i = 0; i < n; ++i) {
            dOMInput.openElement(i);
            String string = dOMInput.getTagName();
            if (string.equals("title")) {
                this.title = dOMInput.getText();
                dOMInput.closeElement();
                continue;
            }
            if (string.equals("desc")) {
                this.description = dOMInput.getText();
                dOMInput.closeElement();
                continue;
            }
            if (string.equals("defs")) {
                dOMInput.closeElement();
                continue;
            }
            if (string.equals("use")) {
                dOMInput.closeElement();
                continue;
            }
            if (string.equals("script")) {
                dOMInput.closeElement();
                continue;
            }
            if (string.equals("style")) {
                dOMInput.closeElement();
                continue;
            }
            if (string.equals("radialGradient")) {
                dOMInput.closeElement();
                continue;
            }
            dOMInput.closeElement();
            Object object = dOMInput.readObject(i);
            if (object instanceof SVGDrawing) {
                SVGGroup sVGGroup = new SVGGroup();
                sVGGroup.willChange();
                for (Figure figure : ((SVGDrawing)object).getFigures()) {
                    sVGGroup.basicAdd(figure);
                }
                sVGGroup.changed();
                if (sVGGroup.isEmpty()) continue;
                this.add(sVGGroup);
                continue;
            }
            if (object instanceof SVGFigure) {
                if (((SVGFigure)object).isEmpty()) continue;
                this.add((Figure)object);
                continue;
            }
            throw new IOException("Unexpected child " + object);
        }
        this.readAttributes(dOMInput);
    }

    protected void readAttributes(DOMInput dOMInput) throws IOException {
    }

    public void write(DOMOutput dOMOutput) throws IOException {
        dOMOutput.addAttribute("xmlns", "http://www.w3.org/2000/svg");
        dOMOutput.addAttribute("version", "1.2");
        dOMOutput.addAttribute("baseProfile", "tiny");
        for (Figure figure : this.getFigures()) {
            dOMOutput.writeObject(figure);
        }
    }
}

