/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.samples.svg.figures.SVGText;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGUtil {
    private static final Color INHERIT_COLOR = new Color(0xFFFF00);
    private static final Color CURRENT_COLOR = new Color(0xFFFF00);
    public static final Map<String, Color> SVG_COLORS;
    private static final HashSet pathCommands;

    private SVGUtil() {
    }

    public static AffineTransform getTransform(DOMInput dOMInput, String string) throws IOException {
        return SVGUtil.getTransform(dOMInput.getAttribute(string, ""));
    }

    public static AffineTransform getTransform(String string) throws IOException {
        AffineTransform affineTransform = new AffineTransform();
        if (string != null) {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(97, 122);
            streamTokenizer.wordChars(65, 90);
            streamTokenizer.wordChars(160, 255);
            streamTokenizer.whitespaceChars(0, 32);
            streamTokenizer.whitespaceChars(44, 44);
            streamTokenizer.parseNumbers();
            while (streamTokenizer.nextToken() != -1) {
                double d;
                if (streamTokenizer.ttype != -3) {
                    throw new IOException("Illegal transform " + string);
                }
                String string2 = streamTokenizer.sval;
                if (streamTokenizer.nextToken() != 40) {
                    throw new IOException("'(' not found in transform " + string);
                }
                if (string2.equals("matrix")) {
                    double[] dArray = new double[6];
                    for (int i = 0; i < 6; ++i) {
                        if (streamTokenizer.nextToken() != -2) {
                            throw new IOException("Matrix value " + i + " not found in transform " + string + " token:" + streamTokenizer.ttype + " " + streamTokenizer.sval);
                        }
                        if (streamTokenizer.nextToken() == -3 && streamTokenizer.sval.startsWith("E")) {
                            d = streamTokenizer.nval;
                            streamTokenizer.nval = Double.valueOf(streamTokenizer.nval + streamTokenizer.sval);
                        } else {
                            streamTokenizer.pushBack();
                        }
                        dArray[i] = streamTokenizer.nval;
                    }
                    affineTransform.concatenate(new AffineTransform(dArray));
                } else if (string2.equals("translate")) {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("X-translation value not found in transform " + string);
                    }
                    double d2 = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() == -2) {
                        d = streamTokenizer.nval;
                    } else {
                        streamTokenizer.pushBack();
                        d = 0.0;
                    }
                    affineTransform.translate(d2, d);
                } else if (string2.equals("scale")) {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("X-scale value not found in transform " + string);
                    }
                    double d3 = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() == -2) {
                        d = streamTokenizer.nval;
                    } else {
                        streamTokenizer.pushBack();
                        d = d3;
                    }
                    affineTransform.scale(d3, d);
                } else if (string2.equals("rotate")) {
                    double d4;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Angle value not found in transform " + string);
                    }
                    double d5 = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() == -2) {
                        d = streamTokenizer.nval;
                        if (streamTokenizer.nextToken() != -2) {
                            throw new IOException("Y-center value not found in transform " + string);
                        }
                        d4 = streamTokenizer.nval;
                    } else {
                        streamTokenizer.pushBack();
                        d4 = 0.0;
                        d = 0.0;
                    }
                    affineTransform.rotate(d5 * Math.PI / 180.0, d * Math.PI / 180.0, d4 * Math.PI / 180.0);
                } else if (string2.equals("skewX")) {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Skew angle not found in transform " + string);
                    }
                    double d6 = streamTokenizer.nval;
                    affineTransform.concatenate(new AffineTransform(1.0, 0.0, Math.tan(d6 * Math.PI / 180.0), 1.0, 0.0, 0.0));
                } else if (string2.equals("skewY")) {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Skew angle not found in transform " + string);
                    }
                    double d7 = streamTokenizer.nval;
                    affineTransform.concatenate(new AffineTransform(1.0, Math.tan(d7 * Math.PI / 180.0), 0.0, 1.0, 0.0, 0.0));
                } else {
                    throw new IOException("Unknown transform " + string2 + " in " + string);
                }
                if (streamTokenizer.nextToken() == 41) continue;
                throw new IOException("')' not found in transform " + string);
            }
        }
        return affineTransform;
    }

    public static double getDimension(DOMInput dOMInput, String string) throws IOException {
        return SVGUtil.getDimensionValue(dOMInput, dOMInput.getAttribute(string, "0"));
    }

    public static double getDimensionValue(DOMInput dOMInput, String string) throws IOException {
        double d = 1.0;
        if (string == null || string.length() == 0) {
            return 0.0;
        }
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.endsWith("px")) {
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("pt")) {
            string = string.substring(0, string.length() - 2);
            d = 1.25;
        } else if (string.endsWith("pc")) {
            string = string.substring(0, string.length() - 2);
            d = 15.0;
        } else if (string.endsWith("mm")) {
            string = string.substring(0, string.length() - 2);
            d = 3.543307;
        } else if (string.endsWith("cm")) {
            string = string.substring(0, string.length() - 2);
            d = 35.43307;
        } else if (string.endsWith("in")) {
            string = string.substring(0, string.length() - 2);
            d = 90.0;
        } else if (string.endsWith("em")) {
            string = string.substring(0, string.length() - 2);
            ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
            List<String> list = dOMInput.getInheritedAttribute("style");
            for (String string2 : list) {
                arrayList.add(SVGUtil.getStyles(string2));
            }
            String string3 = SVGUtil.getInheritedAttribute("font-size", dOMInput, arrayList);
            if (string3 != null && !string3.endsWith("em")) {
                d = SVGUtil.getDimensionValue(dOMInput, string3);
            }
        }
        return Double.parseDouble(string) * d;
    }

    public static List<BezierPath> getPath(DOMInput dOMInput, String string) throws IOException {
        return SVGUtil.fromPathData(dOMInput.getAttribute(string, ""));
    }

    public static void setPath(DOMOutput dOMOutput, String string, BezierPath bezierPath) {
        dOMOutput.addAttribute(string, SVGUtil.toPathData(bezierPath));
    }

    public static String toPathData(BezierPath bezierPath) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bezierPath.size() != 0) {
            if (bezierPath.size() == 1) {
                BezierPath.Node node = (BezierPath.Node)bezierPath.get(0);
                stringBuilder.append("M ");
                stringBuilder.append(node.x[0]);
                stringBuilder.append(' ');
                stringBuilder.append(node.y[0]);
                stringBuilder.append(" L ");
                stringBuilder.append(node.x[0]);
                stringBuilder.append(' ');
                stringBuilder.append(node.y[0] + 1.0);
            } else {
                BezierPath.Node node;
                BezierPath.Node node2 = node = (BezierPath.Node)bezierPath.get(0);
                stringBuilder.append("M ");
                stringBuilder.append(node.x[0]);
                stringBuilder.append(' ');
                stringBuilder.append(node.y[0]);
                int n = bezierPath.size();
                for (int i = 1; i < n; ++i) {
                    node2 = node;
                    node = (BezierPath.Node)bezierPath.get(i);
                    if ((node2.mask & 2) == 0) {
                        if ((node.mask & 1) == 0) {
                            stringBuilder.append(" L ");
                            stringBuilder.append(node.x[0]);
                            stringBuilder.append(' ');
                            stringBuilder.append(node.y[0]);
                            continue;
                        }
                        stringBuilder.append(" Q ");
                        stringBuilder.append(node.x[1]);
                        stringBuilder.append(' ');
                        stringBuilder.append(node.y[1]);
                        stringBuilder.append(' ');
                        stringBuilder.append(node.x[0]);
                        stringBuilder.append(' ');
                        stringBuilder.append(node.y[0]);
                        continue;
                    }
                    if ((node.mask & 1) == 0) {
                        stringBuilder.append(" Q ");
                        stringBuilder.append(node.x[2]);
                        stringBuilder.append(' ');
                        stringBuilder.append(node.y[2]);
                        stringBuilder.append(' ');
                        stringBuilder.append(node.x[0]);
                        stringBuilder.append(' ');
                        stringBuilder.append(node.y[0]);
                        continue;
                    }
                    stringBuilder.append(" C ");
                    stringBuilder.append(node2.x[2]);
                    stringBuilder.append(' ');
                    stringBuilder.append(node2.y[2]);
                    stringBuilder.append(' ');
                    stringBuilder.append(node.x[1]);
                    stringBuilder.append(' ');
                    stringBuilder.append(node.y[1]);
                    stringBuilder.append(' ');
                    stringBuilder.append(node.x[0]);
                    stringBuilder.append(' ');
                    stringBuilder.append(node.y[0]);
                }
                if (bezierPath.isClosed()) {
                    if (bezierPath.size() > 1) {
                        node2 = (BezierPath.Node)bezierPath.get(bezierPath.size() - 1);
                        node = (BezierPath.Node)bezierPath.get(0);
                        if ((node2.mask & 2) == 0) {
                            if ((node.mask & 1) == 0) {
                                stringBuilder.append(" L ");
                                stringBuilder.append(node.x[0]);
                                stringBuilder.append(' ');
                                stringBuilder.append(node.y[0]);
                            } else {
                                stringBuilder.append(" Q ");
                                stringBuilder.append(node.x[1]);
                                stringBuilder.append(' ');
                                stringBuilder.append(node.y[1]);
                                stringBuilder.append(' ');
                                stringBuilder.append(node.x[0]);
                                stringBuilder.append(' ');
                                stringBuilder.append(node.y[0]);
                            }
                        } else if ((node.mask & 1) == 0) {
                            stringBuilder.append(" Q ");
                            stringBuilder.append(node2.x[2]);
                            stringBuilder.append(' ');
                            stringBuilder.append(node2.y[2]);
                            stringBuilder.append(' ');
                            stringBuilder.append(node.x[0]);
                            stringBuilder.append(' ');
                            stringBuilder.append(node.y[0]);
                        } else {
                            stringBuilder.append(" C ");
                            stringBuilder.append(node2.x[2]);
                            stringBuilder.append(' ');
                            stringBuilder.append(node2.y[2]);
                            stringBuilder.append(' ');
                            stringBuilder.append(node.x[1]);
                            stringBuilder.append(' ');
                            stringBuilder.append(node.y[1]);
                            stringBuilder.append(' ');
                            stringBuilder.append(node.x[0]);
                            stringBuilder.append(' ');
                            stringBuilder.append(node.y[0]);
                        }
                    }
                    stringBuilder.append(" Z");
                }
            }
        }
        return stringBuilder.toString();
    }

    public static List<BezierPath> fromPathData(String string) throws IOException {
        LinkedList<BezierPath> linkedList = new LinkedList<BezierPath>();
        ArrayList arrayList = null;
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.parseNumbers();
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.whitespaceChars(44, 44);
        int n = 77;
        int n2 = 77;
        block19: while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.ttype > 0) {
                n2 = (char)streamTokenizer.ttype;
            } else {
                n2 = n;
                streamTokenizer.pushBack();
            }
            switch (n2) {
                case 77: {
                    if (arrayList != null) {
                        linkedList.add((BezierPath)arrayList);
                    }
                    arrayList = new BezierPath();
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y = streamTokenizer.nval;
                    ((BezierPath)arrayList).moveTo(double_.x, double_.y);
                    n = 76;
                    continue block19;
                }
                case 109: {
                    if (arrayList != null) {
                        linkedList.add((BezierPath)arrayList);
                    }
                    arrayList = new BezierPath();
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x += streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y += streamTokenizer.nval;
                    ((BezierPath)arrayList).moveTo(double_.x, double_.y);
                    n = 108;
                    continue block19;
                }
                case 90: 
                case 122: {
                    double_.x = ((BezierPath.Node)arrayList.get((int)0)).x[0];
                    double_.y = ((BezierPath.Node)arrayList.get((int)0)).y[0];
                    ((BezierPath)arrayList).setClosed(true);
                    continue block19;
                }
                case 76: {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y = streamTokenizer.nval;
                    ((BezierPath)arrayList).lineTo(double_.x, double_.y);
                    n = 76;
                    continue block19;
                }
                case 108: {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x += streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y += streamTokenizer.nval;
                    ((BezierPath)arrayList).lineTo(double_.x, double_.y);
                    n = 108;
                    continue block19;
                }
                case 72: {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x = streamTokenizer.nval;
                    ((BezierPath)arrayList).lineTo(double_.x, double_.y);
                    n = 72;
                    continue block19;
                }
                case 104: {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x += streamTokenizer.nval;
                    ((BezierPath)arrayList).lineTo(double_.x, double_.y);
                    n = 104;
                    continue block19;
                }
                case 86: {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y = streamTokenizer.nval;
                    ((BezierPath)arrayList).lineTo(double_.x, double_.y);
                    n = 86;
                    continue block19;
                }
                case 118: {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y += streamTokenizer.nval;
                    ((BezierPath)arrayList).lineTo(double_.x, double_.y);
                    n = 118;
                    continue block19;
                }
                case 67: {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_2.x = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_2.y = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_3.x = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_3.y = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y = streamTokenizer.nval;
                    ((BezierPath)arrayList).curveTo(double_2.x, double_2.y, double_3.x, double_3.y, double_.x, double_.y);
                    n = 67;
                    continue block19;
                }
                case 99: {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_2.x = double_.x + streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_2.y = double_.y + streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_3.x = double_.x + streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_3.y = double_.y + streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x += streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y += streamTokenizer.nval;
                    ((BezierPath)arrayList).curveTo(double_2.x, double_2.y, double_3.x, double_3.y, double_.x, double_.y);
                    n = 99;
                    continue block19;
                }
                case 83: {
                    BezierPath.Node node = (BezierPath.Node)arrayList.get(arrayList.size() - 1);
                    double_2.x = node.x[0] * 2.0 - node.x[1];
                    double_2.y = node.y[0] * 2.0 - node.y[1];
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_3.x = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_3.y = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y = streamTokenizer.nval;
                    ((BezierPath)arrayList).curveTo(double_2.x, double_2.y, double_3.x, double_3.y, double_.x, double_.y);
                    n = 83;
                    continue block19;
                }
                case 115: {
                    BezierPath.Node node = (BezierPath.Node)arrayList.get(arrayList.size() - 1);
                    double_2.x = node.x[0] * 2.0 - node.x[1];
                    double_2.y = node.y[0] * 2.0 - node.y[1];
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_3.x = double_.x + streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_3.y = double_.y + streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x += streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y += streamTokenizer.nval;
                    ((BezierPath)arrayList).curveTo(double_2.x, double_2.y, double_3.x, double_3.y, double_.x, double_.y);
                    n = 115;
                    continue block19;
                }
                case 81: {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_2.x = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_2.y = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y = streamTokenizer.nval;
                    ((BezierPath)arrayList).quadTo(double_2.x, double_2.y, double_.x, double_.y);
                    n = 81;
                    continue block19;
                }
                case 113: {
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_2.x = double_.x + streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_2.y = double_.y + streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x += streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y += streamTokenizer.nval;
                    ((BezierPath)arrayList).quadTo(double_2.x, double_2.y, double_.x, double_.y);
                    n = 113;
                    continue block19;
                }
                case 84: {
                    BezierPath.Node node = (BezierPath.Node)arrayList.get(arrayList.size() - 1);
                    double_2.x = node.x[0] * 2.0 - node.x[1];
                    double_2.y = node.y[0] * 2.0 - node.y[1];
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x = streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y = streamTokenizer.nval;
                    ((BezierPath)arrayList).quadTo(double_2.x, double_2.y, double_.x, double_.y);
                    n = 84;
                    continue block19;
                }
                case 116: {
                    BezierPath.Node node = (BezierPath.Node)arrayList.get(arrayList.size() - 1);
                    double_2.x = node.x[0] * 2.0 - node.x[1];
                    double_2.y = node.y[0] * 2.0 - node.y[1];
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.x += streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IOException("Number expected");
                    }
                    double_.y += streamTokenizer.nval;
                    ((BezierPath)arrayList).quadTo(double_2.x, double_2.y, double_.x, double_.y);
                    n = 115;
                    continue block19;
                }
            }
            throw new IOException("Illegal command: " + (char)n2);
        }
        if (arrayList != null) {
            linkedList.add((BezierPath)arrayList);
        }
        return linkedList;
    }

    public static String getInheritedAttribute(String string, DOMInput dOMInput, List<Map<String, String>> list) {
        List<String> list2 = dOMInput.getInheritedAttribute(string);
        for (int i = list2.size() - 1; i >= 0; --i) {
            if (list2.get(i) != null) {
                return list2.get(i);
            }
            if (list.get(i) == null || !list.get(i).containsKey(string)) continue;
            return list.get(i).get(string);
        }
        return null;
    }

    public static void readAttributes(Figure figure, DOMInput dOMInput) throws IOException {
        Color color;
        Color color2;
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        List<String> list = dOMInput.getInheritedAttribute("style");
        for (String object2 : list) {
            arrayList.add(SVGUtil.getStyles(object2));
        }
        Object object3 = SVGUtil.getInheritedAttribute("fill", dOMInput, arrayList);
        if (object3 != null && (color2 = SVGUtil.getColor((String)object3)) != INHERIT_COLOR && color2 != CURRENT_COLOR) {
            AttributeKeys.FILL_COLOR.set(figure, color2);
        }
        if ((object3 = SVGUtil.getInheritedAttribute("fill-rule", dOMInput, arrayList)) != null) {
            AttributeKeys.WINDING_RULE.set(figure, ((String)object3).toUpperCase().equals("NONZERO") ? AttributeKeys.WindingRule.NON_ZERO : AttributeKeys.WindingRule.EVEN_ODD);
        } else {
            AttributeKeys.WINDING_RULE.set(figure, AttributeKeys.WindingRule.NON_ZERO);
        }
        object3 = SVGUtil.getInheritedAttribute("stroke", dOMInput, arrayList);
        if (object3 != null && (color = SVGUtil.getColor((String)object3)) != INHERIT_COLOR && color != CURRENT_COLOR) {
            AttributeKeys.STROKE_COLOR.set(figure, color);
        }
        if ((object3 = SVGUtil.getInheritedAttribute("stroke-width", dOMInput, arrayList)) != null) {
            AttributeKeys.STROKE_WIDTH.set(figure, Double.valueOf((String)object3));
        }
        if ((object3 = SVGUtil.getInheritedAttribute("stroke-miterlimit", dOMInput, arrayList)) != null) {
            AttributeKeys.STROKE_MITER_LIMIT_FACTOR.set(figure, Double.valueOf((String)object3));
        }
        if ((object3 = SVGUtil.getInheritedAttribute("stroke-dasharray", dOMInput, arrayList)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object3, " ,");
            double[] dArray = new double[stringTokenizer.countTokens()];
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                dArray[i] = Double.valueOf(stringTokenizer.nextToken());
            }
            AttributeKeys.STROKE_DASHES.set(figure, dArray);
        }
        if ((object3 = SVGUtil.getInheritedAttribute("stroke-dashoffset", dOMInput, arrayList)) != null) {
            AttributeKeys.STROKE_DASH_PHASE.set(figure, Math.abs(Double.valueOf((String)object3)));
        }
        if ((object3 = SVGUtil.getInheritedAttribute("font-size", dOMInput, arrayList)) != null) {
            AttributeKeys.FONT_SIZE.set(figure, SVGUtil.getDimensionValue(dOMInput, (String)object3));
        }
        if ((object3 = SVGUtil.getInheritedAttribute("text-anchor", dOMInput, arrayList)) != null) {
            SVGText.TEXT_ANCHOR.set(figure, Enum.valueOf(SVGText.TextAnchor.class, ((String)object3).toUpperCase()));
        }
    }

    public static Map<String, String> getStyles(String string) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null) {
            return hashMap;
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 57);
        streamTokenizer.wordChars(60, 126);
        streamTokenizer.wordChars(160, 255);
        streamTokenizer.whitespaceChars(0, 32);
        while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.ttype == 59) continue;
            if (streamTokenizer.ttype != -3) {
                throw new IOException("Key token expected in " + string + " " + Integer.toHexString(streamTokenizer.ttype));
            }
            String string2 = streamTokenizer.sval;
            if (streamTokenizer.nextToken() != 58) {
                throw new IOException("Colon expected after " + string2 + " in " + string);
            }
            if (streamTokenizer.nextToken() != -3) {
                throw new IOException("Value token expected after " + string2 + " in " + string + " " + streamTokenizer.ttype);
            }
            String string3 = streamTokenizer.sval;
            while (streamTokenizer.nextToken() == -3) {
                string3 = string3 + ' ' + streamTokenizer.sval;
            }
            streamTokenizer.pushBack();
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    public static Color getColor(String string) {
        if ((string = string.trim().toLowerCase()).equals("none")) {
            return null;
        }
        if (string.equals("currentColor")) {
            return CURRENT_COLOR;
        }
        if (string.equals("inherit")) {
            return INHERIT_COLOR;
        }
        if (SVG_COLORS.containsKey(string)) {
            return SVG_COLORS.get(string);
        }
        if (string.startsWith("#") && string.length() == 7) {
            return new Color(Integer.decode(string));
        }
        if (string.startsWith("#") && string.length() == 4) {
            int n = Integer.decode(string);
            return new Color(n & 0xF | (n & 0xF) << 4 | (n & 0xF0) << 4 | (n & 0xF0) << 8 | (n & 0xF00) << 8 | (n & 0xF00) << 12);
        }
        if (string.startsWith("rgb")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "() ,");
            stringTokenizer.nextToken();
            Color color = new Color(Integer.decode(stringTokenizer.nextToken()), Integer.decode(stringTokenizer.nextToken()), Integer.decode(stringTokenizer.nextToken()));
            return color;
        }
        return null;
    }

    public static void setDefaults(Figure figure) {
        AttributeKeys.FILL_COLOR.set(figure, Color.black);
        AttributeKeys.STROKE_COLOR.set(figure, null);
        AttributeKeys.STROKE_DASH_FACTOR.set(figure, 1.0);
    }

    public static void writeAttributes(Figure figure, DOMOutput dOMOutput) throws IOException {
        Double d;
        String string;
        Color color = AttributeKeys.FILL_COLOR.get(figure);
        if (color == null) {
            string = "none";
        } else {
            string = "000000" + Integer.toHexString(color.getRGB());
            string = "#" + string.substring(string.length() - 6);
        }
        dOMOutput.addAttribute("fill", string);
        if (AttributeKeys.WINDING_RULE.get(figure) != AttributeKeys.WindingRule.NON_ZERO) {
            dOMOutput.addAttribute("fill-rule", "evenodd");
        }
        if ((color = AttributeKeys.STROKE_COLOR.get(figure)) == null) {
            string = "none";
        } else {
            string = "000000" + Integer.toHexString(color.getRGB());
            string = "#" + string.substring(string.length() - 6);
        }
        dOMOutput.addAttribute("stroke", string);
        dOMOutput.addAttribute("stroke-width", AttributeKeys.STROKE_WIDTH.get(figure), 1.0);
        dOMOutput.addAttribute("stroke-miterlimit", AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(figure) / AttributeKeys.STROKE_WIDTH.get(figure), 4.0);
        double[] dArray = AttributeKeys.STROKE_DASHES.get(figure);
        Double d2 = d = AttributeKeys.STROKE_DASH_FACTOR.get(figure) == null ? AttributeKeys.STROKE_WIDTH.get(figure) : AttributeKeys.STROKE_DASH_FACTOR.get(figure);
        if (dArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < dArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(',');
                    stringBuilder.append(dArray[i] * d);
                }
                dOMOutput.addAttribute("stroke-dasharray", stringBuilder.toString());
            }
        }
        dOMOutput.addAttribute("stroke-dashoffset", AttributeKeys.STROKE_DASH_PHASE.get(figure), 0.0);
        dOMOutput.addAttribute("font-size", AttributeKeys.FONT_SIZE.get(figure));
    }

    static {
        LinkedHashMap<String, Color> linkedHashMap = new LinkedHashMap<String, Color>();
        linkedHashMap.put("black", new Color(0, 0, 0));
        linkedHashMap.put("green", new Color(0, 128, 0));
        linkedHashMap.put("silver", new Color(192, 192, 192));
        linkedHashMap.put("lime", new Color(0, 255, 0));
        linkedHashMap.put("gray", new Color(128, 128, 128));
        linkedHashMap.put("olive", new Color(128, 128, 0));
        linkedHashMap.put("white", new Color(255, 255, 255));
        linkedHashMap.put("yellow", new Color(255, 255, 0));
        linkedHashMap.put("maroon", new Color(128, 0, 0));
        linkedHashMap.put("navy", new Color(0, 0, 128));
        linkedHashMap.put("red", new Color(255, 0, 0));
        linkedHashMap.put("blue", new Color(0, 0, 255));
        linkedHashMap.put("purple", new Color(128, 0, 128));
        linkedHashMap.put("teal", new Color(0, 128, 128));
        linkedHashMap.put("fuchsia", new Color(255, 0, 255));
        linkedHashMap.put("aqua", new Color(0, 255, 255));
        linkedHashMap.put("aliceblue", new Color(240, 248, 255));
        linkedHashMap.put("antiquewhite", new Color(250, 235, 215));
        linkedHashMap.put("aqua", new Color(0, 255, 255));
        linkedHashMap.put("aquamarine", new Color(127, 255, 212));
        linkedHashMap.put("azure", new Color(240, 255, 255));
        linkedHashMap.put("beige", new Color(245, 245, 220));
        linkedHashMap.put("bisque", new Color(255, 228, 196));
        linkedHashMap.put("black", new Color(0, 0, 0));
        linkedHashMap.put("blanchedalmond", new Color(255, 235, 205));
        linkedHashMap.put("blue", new Color(0, 0, 255));
        linkedHashMap.put("blueviolet", new Color(138, 43, 226));
        linkedHashMap.put("brown", new Color(165, 42, 42));
        linkedHashMap.put("burlywood", new Color(222, 184, 135));
        linkedHashMap.put("cadetblue", new Color(95, 158, 160));
        linkedHashMap.put("chartreuse", new Color(127, 255, 0));
        linkedHashMap.put("chocolate", new Color(210, 105, 30));
        linkedHashMap.put("coral", new Color(255, 127, 80));
        linkedHashMap.put("cornflowerblue", new Color(100, 149, 237));
        linkedHashMap.put("cornsilk", new Color(255, 248, 220));
        linkedHashMap.put("crimson", new Color(220, 20, 60));
        linkedHashMap.put("cyan", new Color(0, 255, 255));
        linkedHashMap.put("darkblue", new Color(0, 0, 139));
        linkedHashMap.put("darkcyan", new Color(0, 139, 139));
        linkedHashMap.put("darkgoldenrod", new Color(184, 134, 11));
        linkedHashMap.put("darkgray", new Color(169, 169, 169));
        linkedHashMap.put("darkgreen", new Color(0, 100, 0));
        linkedHashMap.put("darkgrey", new Color(169, 169, 169));
        linkedHashMap.put("darkkhaki", new Color(189, 183, 107));
        linkedHashMap.put("darkmagenta", new Color(139, 0, 139));
        linkedHashMap.put("darkolivegreen", new Color(85, 107, 47));
        linkedHashMap.put("darkorange", new Color(255, 140, 0));
        linkedHashMap.put("darkorchid", new Color(153, 50, 204));
        linkedHashMap.put("darkred", new Color(139, 0, 0));
        linkedHashMap.put("darksalmon", new Color(233, 150, 122));
        linkedHashMap.put("darkseagreen", new Color(143, 188, 143));
        linkedHashMap.put("darkslateblue", new Color(72, 61, 139));
        linkedHashMap.put("darkslategray", new Color(47, 79, 79));
        linkedHashMap.put("darkslategrey", new Color(47, 79, 79));
        linkedHashMap.put("darkturquoise", new Color(0, 206, 209));
        linkedHashMap.put("darkviolet", new Color(148, 0, 211));
        linkedHashMap.put("deeppink", new Color(255, 20, 147));
        linkedHashMap.put("deepskyblue", new Color(0, 191, 255));
        linkedHashMap.put("dimgray", new Color(105, 105, 105));
        linkedHashMap.put("dimgrey", new Color(105, 105, 105));
        linkedHashMap.put("dodgerblue", new Color(30, 144, 255));
        linkedHashMap.put("firebrick", new Color(178, 34, 34));
        linkedHashMap.put("floralwhite", new Color(255, 250, 240));
        linkedHashMap.put("forestgreen", new Color(34, 139, 34));
        linkedHashMap.put("fuchsia", new Color(255, 0, 255));
        linkedHashMap.put("gainsboro", new Color(220, 220, 220));
        linkedHashMap.put("ghostwhite", new Color(248, 248, 255));
        linkedHashMap.put("gold", new Color(255, 215, 0));
        linkedHashMap.put("goldenrod", new Color(218, 165, 32));
        linkedHashMap.put("gray", new Color(128, 128, 128));
        linkedHashMap.put("grey", new Color(128, 128, 128));
        linkedHashMap.put("green", new Color(0, 128, 0));
        linkedHashMap.put("greenyellow", new Color(173, 255, 47));
        linkedHashMap.put("honeydew", new Color(240, 255, 240));
        linkedHashMap.put("hotpink", new Color(255, 105, 180));
        linkedHashMap.put("indianred", new Color(205, 92, 92));
        linkedHashMap.put("indigo", new Color(75, 0, 130));
        linkedHashMap.put("ivory", new Color(255, 255, 240));
        linkedHashMap.put("khaki", new Color(240, 230, 140));
        linkedHashMap.put("lavender", new Color(230, 230, 250));
        linkedHashMap.put("lavenderblush", new Color(255, 240, 245));
        linkedHashMap.put("lawngreen", new Color(124, 252, 0));
        linkedHashMap.put("lemonchiffon", new Color(255, 250, 205));
        linkedHashMap.put("lightblue", new Color(173, 216, 230));
        linkedHashMap.put("lightcoral", new Color(240, 128, 128));
        linkedHashMap.put("lightcyan", new Color(224, 255, 255));
        linkedHashMap.put("lightgoldenrodyellow", new Color(250, 250, 210));
        linkedHashMap.put("lightgray", new Color(211, 211, 211));
        linkedHashMap.put("lightgreen", new Color(144, 238, 144));
        linkedHashMap.put("lightgrey", new Color(211, 211, 211));
        linkedHashMap.put("lightpink", new Color(255, 182, 193));
        linkedHashMap.put("lightsalmon", new Color(255, 160, 122));
        linkedHashMap.put("lightseagreen", new Color(32, 178, 170));
        linkedHashMap.put("lightskyblue", new Color(135, 206, 250));
        linkedHashMap.put("lightslategray", new Color(119, 136, 153));
        linkedHashMap.put("lightslategrey", new Color(119, 136, 153));
        linkedHashMap.put("lightsteelblue", new Color(176, 196, 222));
        linkedHashMap.put("lightyellow", new Color(255, 255, 224));
        linkedHashMap.put("lime", new Color(0, 255, 0));
        linkedHashMap.put("limegreen", new Color(50, 205, 50));
        linkedHashMap.put("linen", new Color(250, 240, 230));
        linkedHashMap.put("magenta", new Color(255, 0, 255));
        linkedHashMap.put("maroon", new Color(128, 0, 0));
        linkedHashMap.put("mediumaquamarine", new Color(102, 205, 170));
        linkedHashMap.put("mediumblue", new Color(0, 0, 205));
        linkedHashMap.put("mediumorchid", new Color(186, 85, 211));
        linkedHashMap.put("mediumpurple", new Color(147, 112, 219));
        linkedHashMap.put("mediumseagreen", new Color(60, 179, 113));
        linkedHashMap.put("mediumslateblue", new Color(123, 104, 238));
        linkedHashMap.put("mediumspringgreen", new Color(0, 250, 154));
        linkedHashMap.put("mediumturquoise", new Color(72, 209, 204));
        linkedHashMap.put("mediumvioletred", new Color(199, 21, 133));
        linkedHashMap.put("midnightblue", new Color(25, 25, 112));
        linkedHashMap.put("mintcream", new Color(245, 255, 250));
        linkedHashMap.put("mistyrose", new Color(255, 228, 225));
        linkedHashMap.put("moccasin", new Color(255, 228, 181));
        linkedHashMap.put("navajowhite", new Color(255, 222, 173));
        linkedHashMap.put("navy", new Color(0, 0, 128));
        linkedHashMap.put("oldlace", new Color(253, 245, 230));
        linkedHashMap.put("olive", new Color(128, 128, 0));
        linkedHashMap.put("olivedrab", new Color(107, 142, 35));
        linkedHashMap.put("orange", new Color(255, 165, 0));
        linkedHashMap.put("orangered", new Color(255, 69, 0));
        linkedHashMap.put("orchid", new Color(218, 112, 214));
        linkedHashMap.put("palegoldenrod", new Color(238, 232, 170));
        linkedHashMap.put("palegreen", new Color(152, 251, 152));
        linkedHashMap.put("paleturquoise", new Color(175, 238, 238));
        linkedHashMap.put("palevioletred", new Color(219, 112, 147));
        linkedHashMap.put("papayawhip", new Color(255, 239, 213));
        linkedHashMap.put("peachpuff", new Color(255, 218, 185));
        linkedHashMap.put("peru", new Color(205, 133, 63));
        linkedHashMap.put("pink", new Color(255, 192, 203));
        linkedHashMap.put("plum", new Color(221, 160, 221));
        linkedHashMap.put("powderblue", new Color(176, 224, 230));
        linkedHashMap.put("purple", new Color(128, 0, 128));
        linkedHashMap.put("red", new Color(255, 0, 0));
        linkedHashMap.put("rosybrown", new Color(188, 143, 143));
        linkedHashMap.put("royalblue", new Color(65, 105, 225));
        linkedHashMap.put("saddlebrown", new Color(139, 69, 19));
        linkedHashMap.put("salmon", new Color(250, 128, 114));
        linkedHashMap.put("sandybrown", new Color(244, 164, 96));
        linkedHashMap.put("seagreen", new Color(46, 139, 87));
        linkedHashMap.put("seashell", new Color(255, 245, 238));
        linkedHashMap.put("sienna", new Color(160, 82, 45));
        linkedHashMap.put("silver", new Color(192, 192, 192));
        linkedHashMap.put("skyblue", new Color(135, 206, 235));
        linkedHashMap.put("slateblue", new Color(106, 90, 205));
        linkedHashMap.put("slategray", new Color(112, 128, 144));
        linkedHashMap.put("slategrey", new Color(112, 128, 144));
        linkedHashMap.put("snow", new Color(255, 250, 250));
        linkedHashMap.put("springgreen", new Color(0, 255, 127));
        linkedHashMap.put("steelblue", new Color(70, 130, 180));
        linkedHashMap.put("tan", new Color(210, 180, 140));
        linkedHashMap.put("teal", new Color(0, 128, 128));
        linkedHashMap.put("thistle", new Color(216, 191, 216));
        linkedHashMap.put("tomato", new Color(255, 99, 71));
        linkedHashMap.put("turquoise", new Color(64, 224, 208));
        linkedHashMap.put("violet", new Color(238, 130, 238));
        linkedHashMap.put("wheat", new Color(245, 222, 179));
        linkedHashMap.put("white", new Color(255, 255, 255));
        linkedHashMap.put("whitesmoke", new Color(245, 245, 245));
        linkedHashMap.put("yellow", new Color(255, 255, 0));
        linkedHashMap.put("yellowgreen", new Color(154, 205, 50));
        linkedHashMap.put("activeborder", UIManager.getColor("activeCaptionBorder"));
        linkedHashMap.put("activecaption", UIManager.getColor("activeCaption"));
        linkedHashMap.put("appworkspace", UIManager.getColor("window"));
        linkedHashMap.put("background", UIManager.getColor("desktop"));
        linkedHashMap.put("buttonface", UIManager.getColor("control"));
        linkedHashMap.put("buttonhighlight", UIManager.getColor("controlHighlight"));
        linkedHashMap.put("buttonshadow", UIManager.getColor("controlShadow"));
        linkedHashMap.put("buttontext", UIManager.getColor("controlText"));
        linkedHashMap.put("captiontext", UIManager.getColor("activeCaptionText"));
        linkedHashMap.put("graytext", UIManager.getColor("textInactiveText"));
        linkedHashMap.put("highlight", UIManager.getColor("textHighlight"));
        linkedHashMap.put("highlighttext", UIManager.getColor("textHighlightText"));
        linkedHashMap.put("inactiveborder", UIManager.getColor("inactiveCaptionBorder"));
        linkedHashMap.put("inactivecaption", UIManager.getColor("inactiveCaption"));
        linkedHashMap.put("inactivecaptiontext", UIManager.getColor("inactiveCaptionText"));
        linkedHashMap.put("infobackground", UIManager.getColor("info"));
        linkedHashMap.put("infotext", UIManager.getColor("infoText"));
        linkedHashMap.put("menu", UIManager.getColor("menu"));
        linkedHashMap.put("menutext", UIManager.getColor("menuText"));
        linkedHashMap.put("scrollbar", UIManager.getColor("scrollbar"));
        linkedHashMap.put("threeddarkshadow", UIManager.getColor("controlDkShadow"));
        linkedHashMap.put("threedface", UIManager.getColor("control"));
        linkedHashMap.put("threedhighlight", UIManager.getColor("controlHighlight"));
        linkedHashMap.put("threedlightshadow", UIManager.getColor("controlLtHighlight"));
        linkedHashMap.put("threedshadow", UIManager.getColor("controlShadow"));
        linkedHashMap.put("window", UIManager.getColor("window"));
        linkedHashMap.put("windowframe", UIManager.getColor("windowBorder"));
        linkedHashMap.put("windowtext", UIManager.getColor("windowText"));
        SVG_COLORS = linkedHashMap;
        pathCommands = new HashSet<String>(Arrays.asList("M", "m", "Z", "z", "L", "l", "H", "h", "V", "v", "C", "c", "S", "s", "Q", "q", "T", "t"));
    }
}

