/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.action;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.samples.svg.figures.SVGPath;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombineAction
extends GroupAction {
    public static final String ID = "selectionCombine";

    public CombineAction(DrawingEditor drawingEditor) {
        super(drawingEditor, new SVGPath());
        this.labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.svg.Labels", Locale.getDefault());
        this.labels.configureAction(this, ID);
    }

    @Override
    protected boolean canGroup() {
        boolean bl;
        boolean bl2 = bl = this.getView().getSelectionCount() > 1;
        if (bl) {
            for (Figure figure : this.getView().getSelectedFigures()) {
                if (figure instanceof SVGPath) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    @Override
    public Collection<Figure> ungroupFigures(DrawingView drawingView, CompositeFigure compositeFigure) {
        LinkedList<Figure> linkedList = new LinkedList<Figure>(compositeFigure.getChildren());
        drawingView.clearSelection();
        compositeFigure.basicRemoveAllChildren();
        LinkedList<Figure> linkedList2 = new LinkedList<Figure>();
        for (Figure figure : linkedList) {
            SVGPath sVGPath = new SVGPath();
            sVGPath.removeAllChildren();
            for (Map.Entry<AttributeKey, Object> entry : compositeFigure.getAttributes().entrySet()) {
                sVGPath.basicSetAttribute(entry.getKey(), entry.getValue());
            }
            sVGPath.add(figure);
            drawingView.getDrawing().basicAdd(sVGPath);
            linkedList2.add(sVGPath);
        }
        drawingView.getDrawing().remove(compositeFigure);
        drawingView.addToSelection(linkedList2);
        return linkedList;
    }

    @Override
    public void groupFigures(DrawingView drawingView, CompositeFigure compositeFigure, Collection<Figure> collection) {
        Collection<Figure> collection2 = drawingView.getDrawing().sort(collection);
        drawingView.getDrawing().basicRemoveAll(collection);
        drawingView.clearSelection();
        drawingView.getDrawing().add(compositeFigure);
        compositeFigure.willChange();
        ((SVGPath)compositeFigure).removeAllChildren();
        for (Map.Entry<AttributeKey, Object> object : collection.iterator().next().getAttributes().entrySet()) {
            compositeFigure.basicSetAttribute(object.getKey(), object.getValue());
        }
        for (Figure figure : collection2) {
            SVGPath sVGPath = (SVGPath)figure;
            for (Figure figure2 : sVGPath.getChildren()) {
                compositeFigure.basicAdd(figure2);
            }
        }
        compositeFigure.changed();
        drawingView.addToSelection(compositeFigure);
    }
}

