/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.jhotdraw.draw.EllipseFigure;
import org.jhotdraw.samples.svg.SVGUtil;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class SVGEllipse
extends EllipseFigure
implements SVGFigure {
    public SVGEllipse() {
        SVGUtil.setDefaults(this);
    }

    public void write(DOMOutput dOMOutput) throws IOException {
        Rectangle2D.Double double_ = this.getBounds();
        dOMOutput.addAttribute("cx", double_.x + double_.width / 2.0);
        dOMOutput.addAttribute("cy", double_.y + double_.height / 2.0);
        dOMOutput.addAttribute("rx", double_.width / 2.0);
        dOMOutput.addAttribute("ry", double_.height / 2.0);
        this.writeAttributes(dOMOutput);
    }

    protected void writeAttributes(DOMOutput dOMOutput) throws IOException {
        SVGUtil.writeAttributes(this, dOMOutput);
    }

    public void read(DOMInput dOMInput) throws IOException {
        double d;
        double d2;
        if (dOMInput.getTagName().equals("circle")) {
            d = d2 = SVGUtil.getDimension(dOMInput, "r");
        } else {
            d = SVGUtil.getDimension(dOMInput, "rx");
            d2 = SVGUtil.getDimension(dOMInput, "ry");
        }
        double d3 = SVGUtil.getDimension(dOMInput, "cx") - d;
        double d4 = SVGUtil.getDimension(dOMInput, "cy") - d2;
        double d5 = d * 2.0;
        double d6 = d2 * 2.0;
        this.setBounds(new Point2D.Double(d3, d4), new Point2D.Double(d3 + d5, d4 + d6));
        this.readAttributes(dOMInput);
        AffineTransform affineTransform = SVGUtil.getTransform(dOMInput, "transform");
        this.basicTransform(affineTransform);
    }

    protected void readAttributes(DOMInput dOMInput) throws IOException {
        SVGUtil.readAttributes(this, dOMInput);
    }

    public boolean isEmpty() {
        Rectangle2D.Double double_ = this.getBounds();
        return double_.width <= 0.0 || double_.height <= 0.0;
    }
}

