/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.RotateHandle;
import org.jhotdraw.samples.svg.SVGDrawing;
import org.jhotdraw.samples.svg.SVGUtil;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGGroup
extends GroupFigure
implements SVGFigure {
    public SVGGroup() {
        SVGUtil.setDefaults(this);
    }

    public LinkedList<Handle> createHandles(int n) {
        LinkedList linkedList;
        if (n == 0) {
            linkedList = (LinkedList)super.createHandles(n);
            linkedList.add(new RotateHandle(this));
        } else {
            linkedList = new LinkedList();
        }
        return linkedList;
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        this.readAttributes(dOMInput);
        int n = dOMInput.getElementCount();
        for (int i = 0; i < n; ++i) {
            dOMInput.openElement(i);
            String object = dOMInput.getTagName();
            if (object.equals("pattern")) {
                dOMInput.closeElement();
                continue;
            }
            if (object.equals("color-profile")) {
                dOMInput.closeElement();
                continue;
            }
            if (object.equals("defs")) {
                dOMInput.closeElement();
                continue;
            }
            if (object.equals("use")) {
                dOMInput.closeElement();
                continue;
            }
            if (object.equals("script")) {
                dOMInput.closeElement();
                continue;
            }
            if (object.equals("filter")) {
                dOMInput.closeElement();
                continue;
            }
            if (object.equals("title")) {
                dOMInput.closeElement();
                continue;
            }
            if (object.equals("desc")) {
                dOMInput.closeElement();
                continue;
            }
            if (object.equals("switch")) {
                dOMInput.closeElement();
                continue;
            }
            if (object.equals("radialGradient")) {
                dOMInput.closeElement();
                continue;
            }
            if (object.equals("linearGradient")) {
                dOMInput.closeElement();
                continue;
            }
            dOMInput.closeElement();
            Object object2 = dOMInput.readObject(i);
            if (object2 instanceof SVGDrawing) {
                SVGGroup sVGGroup = new SVGGroup();
                sVGGroup.willChange();
                for (Figure figure : ((SVGDrawing)object2).getFigures()) {
                    sVGGroup.basicAdd(figure);
                }
                sVGGroup.changed();
                if (sVGGroup.isEmpty()) continue;
                this.add(sVGGroup);
                continue;
            }
            if (object2 instanceof SVGFigure) {
                if (((SVGFigure)object2).isEmpty()) continue;
                this.add((SVGFigure)object2);
                continue;
            }
            throw new IOException("Unexpected child " + object2);
        }
        AffineTransform affineTransform = SVGUtil.getTransform(dOMInput, "transform");
        for (Figure figure : this.getChildren()) {
            figure.basicTransform(affineTransform);
        }
        this.invalidateBounds();
    }

    protected void readAttributes(DOMInput dOMInput) throws IOException {
        SVGUtil.readAttributes(this, dOMInput);
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        for (Figure figure : this.getChildren()) {
            dOMOutput.writeObject(figure);
        }
        this.writeAttributes(dOMOutput);
    }

    protected void writeAttributes(DOMOutput dOMOutput) throws IOException {
        SVGUtil.writeAttributes(this, dOMOutput);
    }

    @Override
    public boolean isEmpty() {
        return this.getChildCount() == 0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        stringBuilder.append('@');
        stringBuilder.append(this.hashCode());
        if (this.getChildCount() > 0) {
            stringBuilder.append('(');
            Iterator<Figure> iterator = this.getChildren().iterator();
            while (iterator.hasNext()) {
                Figure figure = iterator.next();
                stringBuilder.append(figure);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }
}

