/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.LineFigure;
import org.jhotdraw.samples.svg.SVGUtil;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class SVGLine
extends LineFigure
implements SVGFigure {
    public SVGLine() {
        SVGUtil.setDefaults(this);
    }

    public void write(DOMOutput dOMOutput) throws IOException {
        dOMOutput.addAttribute("x1", this.getPoint((int)0).x);
        dOMOutput.addAttribute("y1", this.getPoint((int)0).y);
        dOMOutput.addAttribute("x2", this.getPoint((int)1).x);
        dOMOutput.addAttribute("y2", this.getPoint((int)1).y);
        this.writeAttributes(dOMOutput);
    }

    protected void writeAttributes(DOMOutput dOMOutput) throws IOException {
        SVGUtil.writeAttributes(this, dOMOutput);
    }

    public void read(DOMInput dOMInput) throws IOException {
        this.setBounds(new Point2D.Double(SVGUtil.getDimension(dOMInput, "x1"), SVGUtil.getDimension(dOMInput, "y1")), new Point2D.Double(SVGUtil.getDimension(dOMInput, "x2"), SVGUtil.getDimension(dOMInput, "y2")));
        this.readAttributes(dOMInput);
        AffineTransform affineTransform = SVGUtil.getTransform(dOMInput, "transform");
        this.basicTransform(affineTransform);
    }

    protected void readAttributes(DOMInput dOMInput) throws IOException {
        SVGUtil.readAttributes(this, dOMInput);
    }

    public boolean handleMouseClick(Point2D.Double double_, MouseEvent mouseEvent, DrawingView drawingView) {
        return true;
    }

    public boolean isEmpty() {
        return false;
    }
}

