/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jhotdraw.draw.AbstractAttributedCompositeFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.RotateHandle;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.samples.svg.SVGUtil;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGPath
extends AbstractAttributedCompositeFigure
implements SVGFigure {
    private GeneralPath path;

    public SVGPath() {
        this.add(new BezierFigure());
        SVGUtil.setDefaults(this);
    }

    @Override
    public void drawFigure(Graphics2D graphics2D) {
        this.validatePath();
        if (AttributeKeys.FILL_COLOR.get(this) != null) {
            graphics2D.setColor(AttributeKeys.FILL_COLOR.get(this));
            this.drawFill(graphics2D);
        }
        if (AttributeKeys.STROKE_COLOR.get(this) != null) {
            graphics2D.setStroke(AttributeKeys.getStroke(this));
            graphics2D.setColor(AttributeKeys.STROKE_COLOR.get(this));
            this.drawStroke(graphics2D);
        }
        if (this.isConnectorsVisible()) {
            this.drawConnectors(graphics2D);
        }
    }

    @Override
    public void drawFill(Graphics2D graphics2D) {
        if (this.getChildren().size() > 0) {
            graphics2D.fill(this.path);
        }
    }

    @Override
    public void drawStroke(Graphics2D graphics2D) {
        graphics2D.draw(this.path);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invalidatePath();
    }

    @Override
    protected void validate() {
        this.validatePath();
        super.validate();
    }

    protected void validatePath() {
        if (this.path == null) {
            this.path = new GeneralPath();
            this.path.setWindingRule(AttributeKeys.WINDING_RULE.get(this) == AttributeKeys.WindingRule.EVEN_ODD ? 0 : 1);
            for (Figure figure : this.getChildren()) {
                BezierFigure bezierFigure = (BezierFigure)figure;
                this.path.append(bezierFigure.getBezierPath(), false);
            }
        }
    }

    protected void invalidatePath() {
        this.path = null;
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        this.writePoints(dOMOutput);
        this.writeAttributes(dOMOutput);
    }

    protected void writePoints(DOMOutput dOMOutput) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Figure figure : this.getChildren()) {
            BezierFigure bezierFigure = (BezierFigure)figure;
            stringBuilder.append(SVGUtil.toPathData(bezierFigure.getBezierPath()));
        }
        dOMOutput.addAttribute("d", stringBuilder.toString());
    }

    @Override
    protected void writeAttributes(DOMOutput dOMOutput) throws IOException {
        SVGUtil.writeAttributes(this, dOMOutput);
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        this.readPoints(dOMInput);
        this.readAttributes(dOMInput);
        AffineTransform affineTransform = SVGUtil.getTransform(dOMInput, "transform");
        this.basicTransform(affineTransform);
    }

    protected void readPoints(DOMInput dOMInput) throws IOException {
        this.removeAllChildren();
        if (dOMInput.getTagName().equals("polyline")) {
            BezierPath bezierPath = new BezierPath();
            String string = dOMInput.getAttribute("points", "");
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                bezierPath.add(new BezierPath.Node(Double.valueOf(stringTokenizer.nextToken()), Double.valueOf(stringTokenizer.nextToken())));
            }
            BezierFigure bezierFigure = new BezierFigure();
            bezierFigure.basicSetBezierPath(bezierPath);
            this.basicAdd(bezierFigure);
        } else if (dOMInput.getTagName().equals("polygon")) {
            BezierPath bezierPath = new BezierPath();
            bezierPath.setClosed(true);
            String string = dOMInput.getAttribute("points", "");
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                bezierPath.add(new BezierPath.Node(Double.valueOf(stringTokenizer.nextToken()), Double.valueOf(stringTokenizer.nextToken())));
            }
            BezierFigure bezierFigure = new BezierFigure();
            bezierFigure.basicSetBezierPath(bezierPath);
            this.basicAdd(bezierFigure);
        } else {
            List<BezierPath> list = SVGUtil.getPath(dOMInput, "d");
            for (BezierPath bezierPath : list) {
                BezierFigure bezierFigure = new BezierFigure();
                bezierFigure.basicSetBezierPath(bezierPath);
                this.basicAdd(bezierFigure);
            }
            if (list.size() == 0) {
                BezierFigure bezierFigure = new BezierFigure();
                this.basicAdd(bezierFigure);
            }
        }
    }

    @Override
    protected void readAttributes(DOMInput dOMInput) throws IOException {
        SVGUtil.readAttributes(this, dOMInput);
    }

    @Override
    public void basicTransform(AffineTransform affineTransform) {
        super.basicTransform(affineTransform);
        this.invalidatePath();
    }

    @Override
    public boolean isEmpty() {
        for (Figure figure : this.getChildren()) {
            BezierFigure bezierFigure = (BezierFigure)figure;
            if (bezierFigure.getPointCount() <= 0) continue;
            return false;
        }
        return true;
    }

    public LinkedList<Handle> createHandles(int n) {
        LinkedList linkedList;
        if (n == 0) {
            linkedList = (LinkedList)super.createHandles(n);
            linkedList.add(new RotateHandle(this));
        } else {
            linkedList = new LinkedList();
            for (Figure figure : this.getChildren()) {
                linkedList.addAll(figure.createHandles(n));
            }
        }
        return linkedList;
    }

    @Override
    public Collection<Action> getActions(Point2D.Double double_) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.svg.Labels");
        LinkedList<Action> linkedList = new LinkedList<Action>();
        linkedList.add(new AbstractAction(resourceBundleUtil.getString("closePath")){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Figure figure : SVGPath.this.getChildren()) {
                    BezierFigure bezierFigure = (BezierFigure)figure;
                    bezierFigure.setClosed(true);
                }
            }
        });
        linkedList.add(new AbstractAction(resourceBundleUtil.getString("openPath")){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Figure figure : SVGPath.this.getChildren()) {
                    BezierFigure bezierFigure = (BezierFigure)figure;
                    bezierFigure.setClosed(false);
                }
            }
        });
        linkedList.add(new AbstractAction(resourceBundleUtil.getString("windingEvenOdd")){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeKeys.WINDING_RULE.set(SVGPath.this, AttributeKeys.WindingRule.EVEN_ODD);
            }
        });
        linkedList.add(new AbstractAction(resourceBundleUtil.getString("windingNonZero")){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeKeys.WINDING_RULE.set(SVGPath.this, AttributeKeys.WindingRule.NON_ZERO);
            }
        });
        return linkedList;
    }
}

