/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.jhotdraw.draw.RoundRectangleFigure;
import org.jhotdraw.samples.svg.SVGUtil;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class SVGRect
extends RoundRectangleFigure
implements SVGFigure {
    public SVGRect() {
        SVGUtil.setDefaults(this);
    }

    public void read(DOMInput dOMInput) throws IOException {
        double d = SVGUtil.getDimension(dOMInput, "x");
        double d2 = SVGUtil.getDimension(dOMInput, "y");
        double d3 = SVGUtil.getDimension(dOMInput, "width");
        double d4 = SVGUtil.getDimension(dOMInput, "height");
        this.setBounds(new Point2D.Double(d, d2), new Point2D.Double(d + d3, d2 + d4));
        this.setArc(SVGUtil.getDimension(dOMInput, "rx"), SVGUtil.getDimension(dOMInput, "ry"));
        this.readAttributes(dOMInput);
        AffineTransform affineTransform = SVGUtil.getTransform(dOMInput, "transform");
        this.basicTransform(affineTransform);
    }

    protected void readAttributes(DOMInput dOMInput) throws IOException {
        SVGUtil.readAttributes(this, dOMInput);
    }

    public void write(DOMOutput dOMOutput) throws IOException {
        Rectangle2D.Double double_ = this.getBounds();
        dOMOutput.addAttribute("x", double_.x);
        dOMOutput.addAttribute("y", double_.y);
        dOMOutput.addAttribute("width", double_.width);
        dOMOutput.addAttribute("height", double_.height);
        dOMOutput.addAttribute("rx", this.getArcWidth());
        dOMOutput.addAttribute("ry", this.getArcHeight());
        this.writeAttributes(dOMOutput);
    }

    protected void writeAttributes(DOMOutput dOMOutput) throws IOException {
        SVGUtil.writeAttributes(this, dOMOutput);
    }

    public boolean isEmpty() {
        Rectangle2D.Double double_ = this.getBounds();
        return double_.width <= 0.0 || double_.height <= 0.0;
    }
}

