/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.samples.svg.SVGUtil;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class SVGText
extends TextFigure
implements SVGFigure {
    public static final AttributeKey<TextAnchor> TEXT_ANCHOR = new AttributeKey<TextAnchor>("textAnchor", TextAnchor.START, false);

    public SVGText() {
        SVGUtil.setDefaults(this);
    }

    protected void drawStroke(Graphics2D graphics2D) {
        if (this.getText() != null || this.isEditable()) {
            Rectangle2D.Double double_ = this.getBounds();
            TextLayout textLayout = this.getTextLayout();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(this.origin.x, this.origin.y + (double)textLayout.getAscent());
            Shape shape = textLayout.getOutline(affineTransform);
            graphics2D.draw(shape);
        }
    }

    protected void drawFill(Graphics2D graphics2D) {
        if (this.getText() != null || this.isEditable()) {
            TextLayout textLayout = this.getTextLayout();
            textLayout.draw(graphics2D, (float)this.origin.x, (float)(this.origin.y + (double)textLayout.getAscent()));
        }
    }

    protected void drawText(Graphics2D graphics2D) {
    }

    public void write(DOMOutput dOMOutput) {
        dOMOutput.addAttribute("x", this.origin.x);
        dOMOutput.addAttribute("y", this.origin.y);
        dOMOutput.addText(this.getText());
    }

    protected void writeAttributes(DOMOutput dOMOutput) throws IOException {
        SVGUtil.writeAttributes(this, dOMOutput);
    }

    public void read(DOMInput dOMInput) throws IOException {
        this.origin.x = SVGUtil.getDimension(dOMInput, "x");
        this.origin.y = SVGUtil.getDimension(dOMInput, "y");
        this.setText(dOMInput.getText());
        this.readAttributes(dOMInput);
        AffineTransform affineTransform = SVGUtil.getTransform(dOMInput, "transform");
        this.basicTransform(affineTransform);
        Rectangle2D.Double double_ = this.getBounds();
        switch (TEXT_ANCHOR.get(this)) {
            case START: {
                break;
            }
            case MIDDLE: {
                this.origin.x -= double_.width / 2.0;
                break;
            }
            case END: {
                this.origin.x -= double_.width;
            }
        }
        this.origin.y -= AttributeKeys.FONT_SIZE.get(this).doubleValue();
    }

    protected void readAttributes(DOMInput dOMInput) throws IOException {
        SVGUtil.readAttributes(this, dOMInput);
    }

    public Color getTextColor() {
        return AttributeKeys.FILL_COLOR.get(this);
    }

    public Color getFillColor() {
        return Color.white;
    }

    public boolean isEmpty() {
        return this.getText() == null || this.getText().length() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextAnchor {
        START,
        MIDDLE,
        END;

    }
}

