/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.undo;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class UndoRedoManager
extends UndoManager {
    protected PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private static final boolean DEBUG = false;
    private static ResourceBundleUtil labels;
    private boolean hasSignificantEdits = false;
    private boolean undoOrRedoInProgress;
    public static final UndoableEdit DISCARD_ALL_EDITS;
    private UndoAction undoAction;
    private RedoAction redoAction;

    public static ResourceBundleUtil getLabels() {
        if (labels == null) {
            labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.undo.Labels");
        }
        return labels;
    }

    public UndoRedoManager() {
        UndoRedoManager.getLabels();
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
    }

    public void setLocale(Locale locale) {
        labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.undo.Labels", locale);
    }

    public void discardAllEdits() {
        super.discardAllEdits();
        this.updateActions();
        this.setHasSignificantEdits(false);
    }

    public void setHasSignificantEdits(boolean bl) {
        boolean bl2 = this.hasSignificantEdits;
        this.hasSignificantEdits = bl;
        this.firePropertyChange("hasSignificantEdits", bl2, bl);
    }

    public boolean hasSignificantEdits() {
        return this.hasSignificantEdits;
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        if (this.undoOrRedoInProgress) {
            undoableEdit.die();
            return true;
        }
        boolean bl = super.addEdit(undoableEdit);
        this.updateActions();
        if (bl && undoableEdit.isSignificant() && this.editToBeUndone() == undoableEdit) {
            this.setHasSignificantEdits(true);
        }
        return bl;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    private void updateActions() {
        String string;
        if (this.canUndo()) {
            this.undoAction.setEnabled(true);
            string = this.getUndoPresentationName();
        } else {
            this.undoAction.setEnabled(false);
            string = labels.getString("undo");
        }
        this.undoAction.putValue("Name", string);
        this.undoAction.putValue("ShortDescription", string);
        if (this.canRedo()) {
            this.redoAction.setEnabled(true);
            string = this.getRedoPresentationName();
        } else {
            this.redoAction.setEnabled(false);
            string = labels.getString("redo");
        }
        this.redoAction.putValue("Name", string);
        this.redoAction.putValue("ShortDescription", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() throws CannotUndoException {
        this.undoOrRedoInProgress = true;
        try {
            super.undo();
        }
        finally {
            this.undoOrRedoInProgress = false;
            this.updateActions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() throws CannotUndoException {
        this.undoOrRedoInProgress = true;
        try {
            super.redo();
        }
        finally {
            this.undoOrRedoInProgress = false;
            this.updateActions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoOrRedo() throws CannotUndoException, CannotRedoException {
        this.undoOrRedoInProgress = true;
        try {
            super.undoOrRedo();
        }
        finally {
            this.undoOrRedoInProgress = false;
            this.updateActions();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.propertySupport.firePropertyChange(string, bl, bl2);
    }

    protected void firePropertyChange(String string, int n, int n2) {
        this.propertySupport.firePropertyChange(string, n, n2);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertySupport.firePropertyChange(string, object, object2);
    }

    static {
        DISCARD_ALL_EDITS = new AbstractUndoableEdit(){

            public boolean canUndo() {
                return false;
            }

            public boolean canRedo() {
                return false;
            }
        };
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            labels.configureAction(this, "redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                UndoRedoManager.this.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.out.println("Cannot redo: " + cannotRedoException);
            }
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            labels.configureAction(this, "undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                UndoRedoManager.this.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                System.err.println("Cannot undo: " + cannotUndoException);
                cannotUndoException.printStackTrace();
            }
        }
    }
}

