/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLParserFactory;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMStorable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NanoXMLDOMInput
implements DOMInput {
    private HashMap<String, Object> idobjects = new HashMap();
    private XMLElement document;
    private XMLElement current;
    private DOMFactory factory;
    private Stack<XMLElement> stack = new Stack();

    public NanoXMLDOMInput(DOMFactory dOMFactory, InputStream inputStream) throws IOException {
        this(dOMFactory, new InputStreamReader(inputStream, "UTF8"));
    }

    public NanoXMLDOMInput(DOMFactory dOMFactory, Reader reader) throws IOException {
        this.factory = dOMFactory;
        try {
            IXMLParser iXMLParser = XMLParserFactory.createDefaultXMLParser();
            StdXMLReader stdXMLReader = new StdXMLReader(reader);
            iXMLParser.setReader(stdXMLReader);
            this.document = new XMLElement();
            this.current = (XMLElement)iXMLParser.parse();
            this.document.addChild(this.current);
            this.current = this.document;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    @Override
    public String getTagName() {
        return this.current.getName();
    }

    @Override
    public String getAttribute(String string, String string2) {
        String string3 = this.current.getAttribute(string);
        return string3 == null || string3.length() == 0 ? string2 : string3;
    }

    @Override
    public List<String> getInheritedAttribute(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (XMLElement xMLElement : this.stack) {
            String string2 = xMLElement.getAttribute(string);
            linkedList.add(string2);
        }
        String string3 = this.current.getAttribute(string);
        linkedList.add(string3);
        return linkedList;
    }

    @Override
    public String getText() {
        return this.getText(null);
    }

    @Override
    public String getText(String string) {
        String string2 = this.current.getContent();
        return string2 == null ? string : string2;
    }

    @Override
    public int getAttribute(String string, int n) {
        String string2 = this.current.getAttribute(string);
        return string2 == null || string2.length() == 0 ? n : Long.decode(string2).intValue();
    }

    @Override
    public double getAttribute(String string, double d) {
        String string2 = this.current.getAttribute(string);
        return string2 == null || string2.length() == 0 ? d : Double.parseDouble(string2);
    }

    @Override
    public boolean getAttribute(String string, boolean bl) {
        String string2 = this.current.getAttribute(string);
        return string2 == null || string2.length() == 0 ? bl : Boolean.valueOf(string2);
    }

    @Override
    public int getElementCount() {
        return this.current.getChildrenCount();
    }

    @Override
    public int getElementCount(String string) {
        int n = 0;
        ArrayList arrayList = this.current.getChildren();
        for (int i = 0; i < arrayList.size(); ++i) {
            XMLElement xMLElement = (XMLElement)arrayList.get(i);
            if (!xMLElement.getName().equals(string)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void openElement(int n) {
        this.stack.push(this.current);
        ArrayList arrayList = this.current.getChildren();
        this.current = (XMLElement)arrayList.get(n);
    }

    @Override
    public void openElement(String string) throws IOException {
        ArrayList arrayList = this.current.getChildren();
        for (int i = 0; i < arrayList.size(); ++i) {
            XMLElement xMLElement = (XMLElement)arrayList.get(i);
            if (!xMLElement.getName().equals(string)) continue;
            this.stack.push(this.current);
            this.current = xMLElement;
            return;
        }
        throw new IOException("no such element:" + string);
    }

    @Override
    public void openElement(String string, int n) throws IOException {
        int n2 = 0;
        ArrayList arrayList = this.current.getChildren();
        for (int i = 0; i < arrayList.size(); ++i) {
            XMLElement xMLElement = (XMLElement)arrayList.get(i);
            if (!xMLElement.getName().equals(string) || n2++ != n) continue;
            this.stack.push(this.current);
            this.current = xMLElement;
            return;
        }
        throw new IOException("no such element:" + string + " at index:" + n);
    }

    @Override
    public void closeElement() {
        this.current = this.stack.pop();
    }

    @Override
    public Object readObject() throws IOException {
        return this.readObject(0);
    }

    @Override
    public Object readObject(int n) throws IOException {
        Object object;
        this.openElement(n);
        String string = this.getTagName();
        if (string.equals("null")) {
            object = null;
        } else if (string.equals("string")) {
            object = this.getText();
        } else if (string.equals("int")) {
            object = Integer.decode(this.getText());
        } else if (string.equals("long")) {
            object = Long.decode(this.getText());
        } else if (string.equals("float")) {
            object = new Float(Float.parseFloat(this.getText()));
        } else if (string.equals("double")) {
            object = new Double(Double.parseDouble(this.getText()));
        } else if (string.equals("boolean")) {
            object = Boolean.valueOf(this.getText());
        } else if (string.equals("color")) {
            object = new Color(this.getAttribute("rgba", 255));
        } else if (string.equals("intArray")) {
            int[] nArray = new int[this.getElementCount()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)this.readObject(i);
            }
            object = nArray;
        } else if (string.equals("floatArray")) {
            float[] fArray = new float[this.getElementCount()];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = ((Float)this.readObject(i)).floatValue();
            }
            object = fArray;
        } else if (string.equals("doubleArray")) {
            double[] dArray = new double[this.getElementCount()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (Double)this.readObject(i);
            }
            object = dArray;
        } else if (string.equals("font")) {
            object = new Font(this.getAttribute("name", "Dialog"), this.getAttribute("style", 0), this.getAttribute("size", 0));
        } else if (string.equals("enum")) {
            object = this.factory.createEnum(this.getAttribute("type", null), this.getText());
        } else {
            String string2 = this.getAttribute("ref", null);
            String string3 = this.getAttribute("id", string2);
            if (string3 == null) {
                object = this.factory.create(this.getTagName());
            } else if (this.idobjects.containsKey(string3)) {
                object = this.idobjects.get(string3);
            } else {
                object = this.factory.create(this.getTagName());
                this.idobjects.put(string3, object);
            }
            if (string2 == null && object instanceof DOMStorable) {
                ((DOMStorable)object).read(this);
            }
        }
        this.closeElement();
        return object;
    }
}

