/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.action;

import org.jemmy.action.Action;
import org.jemmy.action.ActionExecutor;
import org.jemmy.action.ActionQueue;
import org.jemmy.env.Environment;
import org.jemmy.env.TestOut;
import org.jemmy.env.Timeout;
import org.jemmy.timing.State;
import org.jemmy.timing.Waiter;

public abstract class AbstractExecutor
implements ActionExecutor {
    public static final Timeout MAX_ACTION_TIME = new Timeout("max.action.time", 60000L);
    public static final String NON_QUEUE_ACTION_OUTPUT = "org.jemmy.action.AbstractExecutor.NON_QUEUE_ACTION_OUTPUT";
    public static final String QUEUE_ACTION_OUTPUT = "org.jemmy.action.AbstractExecutor.QUEUE_ACTION_OUTPUT";
    private ActionQueue queue = new ActionQueue();

    protected int actionsInQueue() {
        return this.queue.actionsInQueue();
    }

    public final void execute(Environment env, boolean dispatch, Action action, Object ... parameters) {
        this.printStrace(env, "Action: ", action);
        action.setAllowedTime(env.getTimeout(MAX_ACTION_TIME.getName()).getValue());
        if (dispatch) {
            this.executeQueue(env, action, parameters);
        } else if (this.isInAction()) {
            action.execute(parameters);
        } else {
            this.queue.invokeAndWait(action, parameters);
        }
    }

    public final void executeDetached(Environment env, boolean dispatch, final Action action, final Object ... parameters) {
        this.printStrace(env, "Action detached: ", action);
        if (dispatch) {
            this.executeQueueDetached(env, action, parameters);
        } else if (this.isInAction()) {
            new Thread(new Runnable(){

                public void run() {
                    action.execute(parameters);
                }
            }).start();
        } else {
            this.queue.invoke(action, parameters);
        }
    }

    private void printStrace(Environment env, String text, Action action) {
        String toString = action.toString();
        if (toString != null && toString.length() > 0 && !this.isInAction()) {
            if (this.isOnQueue()) {
                env.getOutput(QUEUE_ACTION_OUTPUT).println(text + action.toString());
            } else {
                env.getOutput(NON_QUEUE_ACTION_OUTPUT).println(text + action.toString());
            }
        }
    }

    public final boolean isInAction() {
        return this.queue.getQueueThread() == Thread.currentThread() || this.isOnQueue();
    }

    public abstract void executeQueue(Environment var1, Action var2, Object ... var3);

    public abstract void executeQueueDetached(Environment var1, Action var2, Object ... var3);

    public abstract boolean isOnQueue();

    public void waitQuiet(Timeout waitTime) {
        new Waiter(waitTime).ensureState(new State<Object>(){

            @Override
            public Object reached() {
                return AbstractExecutor.this.isQuiet() ? Boolean.valueOf(true) : null;
            }
        });
    }

    protected abstract boolean isQuiet();

    static {
        Environment.getEnvironment().initTimeout(MAX_ACTION_TIME);
        Environment.getEnvironment().initOutput(QUEUE_ACTION_OUTPUT, TestOut.getNullOutput());
        Environment.getEnvironment().initOutput(NON_QUEUE_ACTION_OUTPUT, TestOut.getNullOutput());
    }
}

