/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.action;

import org.jemmy.JemmyException;

public abstract class Action {
    private boolean interrupted = false;
    private long startTime = -1L;
    private long endTime = 0L;
    private long allowedTime = 0L;
    private Throwable throwable = null;

    public final void execute(Object ... parameters) {
        this.startTime = System.currentTimeMillis();
        try {
            this.run(parameters);
        }
        catch (Error e) {
            this.throwable = e;
            throw e;
        }
        catch (RuntimeException e) {
            this.throwable = e;
            throw e;
        }
        catch (Exception e) {
            this.throwable = e;
            throw new JemmyException("Exception in action " + this.toString(), e);
        }
        finally {
            this.endTime = System.currentTimeMillis();
        }
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected boolean withinAllowedTime() {
        return System.currentTimeMillis() - this.startTime < this.allowedTime;
    }

    public long getAllowedTime() {
        return this.allowedTime;
    }

    public void setAllowedTime(long allowedTime) {
        this.allowedTime = allowedTime;
    }

    public abstract void run(Object ... var1) throws Exception;

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean failed() {
        return this.throwable != null;
    }

    public String toString() {
        return super.toString();
    }
}

