/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.control;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jemmy.control.Wrap;
import org.jemmy.control.Wrapper;
import org.jemmy.control.WrapperException;
import org.jemmy.env.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWrapper
implements Wrapper {
    private Environment env;

    public AbstractWrapper(Environment env) {
        this.env = env;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    protected abstract Class<Wrap> getWrapClass(Class var1);

    @Override
    public <T> Wrap<? extends T> wrap(Class<T> controlClass, T control) {
        Class<?> cls = control.getClass();
        do {
            Class<Wrap> wrp;
            if ((wrp = this.getWrapClass(cls)) == null) continue;
            try {
                return this.doWrap(control, cls, wrp);
            }
            catch (InstantiationException ex) {
                throw new WrapperException(cls, wrp, ex);
            }
            catch (IllegalAccessException ex) {
                throw new WrapperException(cls, wrp, ex);
            }
            catch (IllegalArgumentException ex) {
                throw new WrapperException(cls, wrp, ex);
            }
            catch (InvocationTargetException ex) {
                throw new WrapperException(cls, wrp, ex);
            }
            catch (NoSuchMethodException ex) {
                throw new WrapperException(cls, wrp, ex);
            }
            catch (SecurityException ex) {
                throw new WrapperException(cls, wrp, ex);
            }
        } while ((cls = cls.getSuperclass()) != null);
        throw new WrapperException(control);
    }

    protected <T> Wrap<? extends T> doWrap(T control, Class controlClass, Class wrapperClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor cns = null;
        Class cls = controlClass;
        do {
            try {
                cns = wrapperClass.getConstructor(Environment.class, cls);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        } while ((cls = cls.getSuperclass()) != null);
        if (cns != null) {
            return (Wrap)cns.newInstance(new Environment(this.env), control);
        }
        throw new WrapperException(controlClass, wrapperClass);
    }
}

