/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.control;

import org.jemmy.JemmyException;
import org.jemmy.control.Wrap;
import org.jemmy.interfaces.Selectable;
import org.jemmy.interfaces.Selector;
import org.jemmy.interfaces.Showable;
import org.jemmy.timing.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorImpl<CONTROL, STATE>
implements Selector<STATE> {
    Wrap<? extends CONTROL> target;
    Selectable<STATE> selectable;

    public SelectorImpl(Wrap<? extends CONTROL> target, Selectable<STATE> selectable) {
        this.target = target;
        this.selectable = selectable;
    }

    @Override
    public void select(final STATE state) {
        if (this.target.is(Showable.class)) {
            this.target.as(Showable.class).shower().show();
        }
        int attempts = 0;
        if (!this.selectable.getState().equals(state)) {
            do {
                final STATE currentState = this.selectable.getState();
                if (attempts >= this.selectable.getStates().size()) {
                    throw new JemmyException("State is not reached in " + attempts + " attempts", state);
                }
                this.target.mouse().click(this.clickCount(state));
                this.target.getEnvironment().getWaiter(Wrap.WAIT_STATE_TIMEOUT.getName()).ensureState(new State(){

                    public Object reached() {
                        return SelectorImpl.this.selectable.getState().equals(currentState) ? null : "";
                    }

                    public String toString() {
                        return "selectable state (" + SelectorImpl.this.selectable.getState() + ") equals '" + state + "'";
                    }
                });
                ++attempts;
            } while (!this.selectable.getState().equals(state));
        }
    }

    private int clickCount(STATE state) {
        int current = this.selectable.getStates().indexOf(this.selectable.getState());
        int desired = this.selectable.getStates().indexOf(state);
        if (desired >= current) {
            return desired - current;
        }
        return this.selectable.getStates().size() - current + desired;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StateChangeState
    implements State<STATE> {
        Selectable<STATE> source;
        STATE original;

        public StateChangeState(Selectable<STATE> source) {
            this.source = source;
            this.original = source.getState();
        }

        @Override
        public STATE reached() {
            return this.source.getState() != this.original ? (Object)this.source.getState() : null;
        }
    }
}

