/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.dock;

import org.jemmy.Rectangle;
import org.jemmy.action.GetAction;
import org.jemmy.control.Wrap;
import org.jemmy.env.Environment;
import org.jemmy.interfaces.Drag;
import org.jemmy.interfaces.Keyboard;
import org.jemmy.interfaces.Mouse;
import org.jemmy.interfaces.Parent;
import org.jemmy.lookup.Lookup;
import org.jemmy.lookup.LookupCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dock {
    public static final String DEFAULT_RESULT_IMAGE_SUFFIX = "default.result.image.suffix";
    public static final String DEFAULT_DIFF_IMAGE_SUFFIX = "default.diff.image.suffix";
    private Wrap<?> wrap;

    protected Dock(Wrap<?> wrap) {
        this.wrap = wrap;
    }

    protected static <T> Wrap<? extends T> lookup(Parent<? super T> parent, Class<T> controlType, int index, LookupCriteria<T> ... criteria) {
        Lookup<T> lookup;
        if (criteria.length > 0) {
            lookup = parent.lookup(controlType, criteria[0]);
            for (int i = 1; i < criteria.length; ++i) {
                lookup = lookup.lookup(controlType, criteria[i]);
            }
        } else {
            lookup = parent.lookup(controlType);
        }
        return lookup.wrap(index);
    }

    public Wrap<?> wrap() {
        return this.wrap;
    }

    public Object control() {
        return this.wrap.getControl();
    }

    public Mouse mouse() {
        return this.wrap.mouse();
    }

    public Keyboard keyboard() {
        return this.wrap.keyboard();
    }

    public Drag drag() {
        return this.wrap.drag();
    }

    public Rectangle bounds() {
        return this.wrap.getScreenBounds();
    }

    protected <P> P getProperty(GetAction<P> action) {
        action.execute(new Object[0]);
        return action.getResult();
    }

    public Environment environment() {
        return this.wrap.getEnvironment();
    }

    public void waitImage(String goldenId, Rectangle rect, String resID, String diffID) {
        this.wrap.waitImage(this.environment().getImageLoader().load(goldenId), rect, resID, diffID);
    }

    public void waitImage(String goldenId, Rectangle rect) {
        this.waitImage(goldenId, rect, goldenId + this.environment().getProperty(DEFAULT_RESULT_IMAGE_SUFFIX), goldenId + this.environment().getProperty(DEFAULT_DIFF_IMAGE_SUFFIX));
    }

    public void waitImage(String goldenId, String resID, String diffID) {
        this.wrap.waitImage(this.environment().getImageLoader().load(goldenId), resID, diffID);
    }

    public void waitImage(String goldenId) {
        this.waitImage(goldenId, goldenId + this.environment().getProperty(DEFAULT_RESULT_IMAGE_SUFFIX), goldenId + this.environment().getProperty(DEFAULT_DIFF_IMAGE_SUFFIX));
    }

    static {
        Environment.getEnvironment().setPropertyIfNotSet(DEFAULT_DIFF_IMAGE_SUFFIX, "-diff");
        Environment.getEnvironment().setPropertyIfNotSet(DEFAULT_RESULT_IMAGE_SUFFIX, "-result");
    }
}

