/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.dock;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractAnnotationValueVisitor6;
import javax.lang.model.util.AbstractTypeVisitor6;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jemmy.control.ControlInterfaces;
import org.jemmy.control.ControlType;
import org.jemmy.control.FieldProperties;
import org.jemmy.control.MethodProperties;
import org.jemmy.control.Property;
import org.jemmy.control.Wrap;
import org.jemmy.dock.DefaultParent;
import org.jemmy.dock.DefaultWrapper;
import org.jemmy.dock.Dock;
import org.jemmy.dock.DockInfo;
import org.jemmy.dock.ObjectLookup;
import org.jemmy.dock.Shortcut;
import org.jemmy.env.Environment;
import org.jemmy.interfaces.ControlInterface;
import org.jemmy.interfaces.Parent;
import org.jemmy.lookup.LookupCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class DockGenerator
extends AbstractProcessor {
    public static final String CONTROL_PLACEHOLDER = "$CONTROL$";
    public static final String PACKAGE_PLACEHOLDER = "$PACKAGE$";
    public static final String SUPERDOCK_PLACEHOLDER = "$SUPERDOCK$";
    public static final String WRAP_PLACEHOLDER = "$WRAP$";
    private static final String DOCK_PLACEHOLDER = "$DOCK$";
    private static final String body_source = "/**\nThis is a convenience class generated by information available through annotations in class $WRAP$\n*/\npackage $PACKAGE$;\nimport " + Wrap.class.getName() + ";\n" + "import " + Parent.class.getName() + ";\n" + "import " + LookupCriteria.class.getName() + ";\n" + "import " + Environment.class.getName() + ";\n" + "public class $DOCK$ extends $SUPERDOCK$ {\n" + "$CONSTRUCTORS$" + "$WRAP_GETTER$" + "$INTERFACES$" + "$PROPERTIES$" + "}";
    private static final String control_constructor_source = "\t/**Creates dock for a previously found control*/\n\tpublic $DOCK$(Environment env, $CONTROL$ control) {\n\t\tsuper($WRAP_METHOD$(env, $CONTROL$.class, control));\n\t}\n";
    private static final String wrap_constructor_source = "\t/**Creates dock for a wrapped control*/\n\t$PUBLIC$ $DOCK$(Wrap<? extends $CONTROL$> wrap) {\n\t\tsuper(wrap);\n\t}\n";
    private static final String criteria_constructors_source = "\t/**Looks for an <code>index</code>'th <code>$CONTROL$</code> by a criteria within <code>parent</code>*/\n\tpublic $DOCK$(Parent<? super $CONTROL$> parent, int index, LookupCriteria<$CONTROL$>... criteria) {\n\t\tthis(lookup(parent, $CONTROL$.class, index, criteria));\n\t}\n\t/**Looks for a <code>$CONTROL$</code> by a criteria within <code>parent</code>*/\n\tpublic $DOCK$(Parent<? super $CONTROL$> parent, LookupCriteria<$CONTROL$>... criteria) {\n\t\tthis(parent, 0, criteria);\n\t}\n";
    private static final String object_lookup_constructors_source = "\t/**Looks for an <code>index</code>'th <code>$CONTROL$</code> $LOOKUP_DESCRIPTION$ within <code>parent</code>*/\n\tpublic $DOCK$(Parent<? super $CONTROL$> parent, int index$COMMA$ $DECLARED_PARAMETERS$) {\n\t\tthis(parent, index, $USED_PARAMETERS$);\n\t}\n\t/**Looks for a <code>$CONTROL$</code> $LOOKUP_DESCRIPTION$ within <code>parent</code>*/\n\tpublic $DOCK$(Parent<? super $CONTROL$> parent$COMMA$ $DECLARED_PARAMETERS$) {\n\t\tthis(parent, $USED_PARAMETERS$);\n\t}\n";
    private static final String default_parent_criteria_constructors_source = "\t/**Looks for a <code>$CONTROL$</code> by a criteria within $DEFAULT_PARENT_DESCRIPTION$*/\n\tpublic $DOCK$(LookupCriteria<$CONTROL$>... criteria) {\n\t\tthis(0, criteria);\n\t}\n\t/**Looks for an <code>index</code>'th <code>$CONTROL$</code> by a criteria within $DEFAULT_PARENT_DESCRIPTION$*/\n\tpublic $DOCK$(int index, LookupCriteria<$CONTROL$>... criteria) {\n\t\tthis($LOOKUP_METHOD$($CONTROL$.class), index, criteria);\n\t}\n";
    private static final String default_parent_object_lookup_constructors_source = "\t/**Looks for a <code>$CONTROL$</code> $LOOKUP_DESCRIPTION$ within $DEFAULT_PARENT_DESCRIPTION$*/\n\tpublic $DOCK$($DECLARED_PARAMETERS$) {\n\t\tthis(0, $USED_PARAMETERS$);\n\t}\n\t/**Looks for an <code>index</code>'th <code>$CONTROL$</code> $LOOKUP_DESCRIPTION$ within $DEFAULT_PARENT_DESCRIPTION$*/\n\tpublic $DOCK$(int index$COMMA$ $DECLARED_PARAMETERS$) {\n\t\tthis($LOOKUP_METHOD$($CONTROL$.class), index, $USED_PARAMETERS$);\n\t}\n";
    private static final String criteria_subclass_constructors_source = "\t/**Looks for an <code>index</code>'th <code>SUBCLASS</code> by a criteria within <code>parent</code>*/\n\tpublic <SUBCLASS extends $CONTROL$> $DOCK$(Parent<? super $CONTROL$> parent, Class<SUBCLASS> cls, int index, LookupCriteria<SUBCLASS>... criteria) {\n\t\tthis(lookup(parent, cls, index, criteria));\n\t}\n\t/**Looks for a <code>SUBCLASS</code> by a criteria within <code>parent</code>*/\n\tpublic <SUBCLASS extends $CONTROL$> $DOCK$(Parent<? super $CONTROL$> parent, Class<SUBCLASS> cls, LookupCriteria<SUBCLASS>... criteria) {\n\t\tthis(parent, cls, 0, criteria);\n\t}\n";
    private static final String object_lookup_subclass_constructors_source = "\t/**Looks for an <code>index</code>'th <code>SUBCLASS</code> $LOOKUP_DESCRIPTION$ within <code>parent</code>*/\n\tpublic <SUBCLASS extends $CONTROL$> $DOCK$(Parent<? super $CONTROL$> parent, Class<SUBCLASS> cls, int index$COMMA$ $DECLARED_PARAMETERS$) {\n\t\tthis(parent, cls, index, $USED_PARAMETERS$);\n\t}\n\t/**Looks for a <code>SUBCLASS</code> $LOOKUP_DESCRIPTION$ within <code>parent</code>*/\n\tpublic <SUBCLASS extends $CONTROL$> $DOCK$(Parent<? super $CONTROL$> parent, Class<SUBCLASS> cls$COMMA$ $DECLARED_PARAMETERS$) {\n\t\tthis(parent, cls, $USED_PARAMETERS$);\n\t}\n";
    private static final String default_parent_criteria_subclass_constructors_source = "\t/**Looks for a <code>SUBCLASS</code> by a criteria within $DEFAULT_PARENT_DESCRIPTION$*/\n\tpublic <SUBCLASS extends $CONTROL$> $DOCK$(Class<SUBCLASS> cls, LookupCriteria<SUBCLASS>... criteria) {\n\t\tthis(cls, 0, criteria);\n\t}\n\t/**Looks for an <code>index</code>'th <code>SUBCLASS</code> by a criteria within $DEFAULT_PARENT_DESCRIPTION$*/\n\tpublic <SUBCLASS extends $CONTROL$> $DOCK$(Class<SUBCLASS> cls, int index, LookupCriteria<SUBCLASS>... criteria) {\n\t\tthis($LOOKUP_METHOD$(cls), cls, index, criteria);\n\t}\n";
    private static final String default_parent_object_lookup_subclass_constructors_source = "\t/**Looks for a <code>SUBCLASS</code> $LOOKUP_DESCRIPTION$ within $DEFAULT_PARENT_DESCRIPTION$*/\n\tpublic <SUBCLASS extends $CONTROL$> $DOCK$(Class<SUBCLASS> cls$COMMA$ $DECLARED_PARAMETERS$) {\n\t\tthis(cls, 0, $USED_PARAMETERS$);\n\t}\n\t/**Looks for an <code>index</code>'th <code>SUBCLASS</code> $LOOKUP_DESCRIPTION$ within $DEFAULT_PARENT_DESCRIPTION$*/\n\tpublic <SUBCLASS extends $CONTROL$> $DOCK$(Class<SUBCLASS> cls, int index$COMMA$ $DECLARED_PARAMETERS$) {\n\t\tthis($LOOKUP_METHOD$(cls), cls, index, $USED_PARAMETERS$);\n\t}\n";
    private static final String wrap_getter_source = "\t/**Returns wrap*/\n\t@Override\n\tpublic $WRAP$<? extends $CONTROL$> wrap() {\n\t\treturn ($WRAP$<? extends $CONTROL$>)super.wrap();\n\t}\n";
    private static final String anon_wrap_getter_source = "\t/**Returns wrap*/\n\t@Override\n\tpublic Wrap<? extends $CONTROL$> wrap() {\n\t\treturn (Wrap<? extends $CONTROL$>)super.wrap();\n\t}\n";
    private static final String interface_getter_source = "\t/**Allows to use as <code>$INTERFACE$</code>*/\n\tpublic $INTERFACE$ $INTERFACE_GETTER$() {\n\t\treturn wrap().as($INTERFACE$.class);\n\t}\n";
    private static final String typed_interface_getter_source = "\t/**Allows to use as <code>$INTERFACE$&lt;$INTERFACE_TYPE$&gt;</code>*/\n\tpublic $INTERFACE$<$INTERFACE_TYPE$> $INTERFACE_GETTER$() {\n\t\treturn wrap().as($INTERFACE$.class, $INTERFACE_TYPE$.class);\n\t}\n";
    private static final String method_property_getter_source = "\t/**Returns a result of <code>$PROP_NAME$()</code> method*/\n\tpublic $PROP_TYPE$ $GETTER_NAME$() {\n\t\treturn getProperty(new org.jemmy.action.GetAction<$PROP_TYPE$>() {\n\t\t\t@Override\n\t\t\tpublic void run(Object... parameters) throws Exception {\n\t\t\t\tsetResult(wrap().getControl().$PROP_NAME$());\n\t\t\t}\n\t\t});\n\t}\n";
    private static final String field_property_getter_source = "\t/**Returns a value of <code>$PROP_NAME$</code> property*/\n\tpublic $PROP_TYPE$ $GETTER_NAME$() {\n\t\treturn getProperty(new org.jemmy.action.GetAction<$PROP_TYPE$>() {\n\t\t\t@Override\n\t\t\tpublic void run(Object... parameters) throws Exception {\n\t\t\t\tsetResult(wrap().getControl().$PROP_NAME$);\n\t\t\t}\n\t\t});\n\t}\n";
    private static final String declared_property_getter_source = "\t/**Returns $PROP_NAME$ property*/\n\tpublic $PROP_TYPE$ $GETTER_NAME$() {\n\t\treturn wrap().$METHOD_NAME$();\n\t}\n";
    private static final String anon_declared_property_getter_source = "\t/**Returns $PROP_NAME$ property*/\n\tpublic $PROP_TYPE$ $GETTER_NAME$() {\n\t\treturn wrap().getProperty($PROP_TYPE$.class, \"$PROP_NAME$\");\n\t}\n";
    private static final String shortcut_methods_source = "\t/**Calls <code>wrap().as($INTERFACE$.class).$INVOKE_SETTER$;</code>*/\n\tpublic $RETURN_TYPE$ $INTERFACE_SETTER$ {\n\t\t $RETURN_STATEMENT$wrap().as($INTERFACE$.class).$INVOKE_SETTER$;\n\t}\n";
    private HashMap<String, String> primitiveTypesSubstitutions = new HashMap();
    Set<String> types;

    public DockGenerator() {
        this.primitiveTypesSubstitutions.put(Integer.TYPE.getName(), Integer.class.getName());
        this.primitiveTypesSubstitutions.put(Long.TYPE.getName(), Long.class.getName());
        this.primitiveTypesSubstitutions.put(Float.TYPE.getName(), Float.class.getName());
        this.primitiveTypesSubstitutions.put(Double.TYPE.getName(), Double.class.getName());
        this.primitiveTypesSubstitutions.put(Boolean.TYPE.getName(), Boolean.class.getName());
        this.types = new HashSet<String>();
        this.types.add(ControlType.class.getName());
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.types;
    }

    private StringBuilder replace(String b, String ... replacements) {
        return this.replace(new StringBuilder(b), replacements);
    }

    private StringBuilder replace(StringBuilder b, String ... replacements) {
        assert (replacements.length % 2 == 0);
        for (int j = 0; j < replacements.length / 2; ++j) {
            int i;
            while ((i = b.indexOf(replacements[j * 2])) > -1) {
                b.replace(i, i + replacements[j * 2].length(), replacements[j * 2 + 1]);
            }
        }
        return b;
    }

    private String generateDockName(Element e, String controlClassName) {
        DockInfo dn = e.getAnnotation(DockInfo.class);
        if (dn != null && dn.name().length() > 0) {
            return dn.name();
        }
        return this.generateDockName(((TypeElement)e).getQualifiedName().toString(), this.getSimpleName(controlClassName));
    }

    private String generateDockName(String wrapClassName, String controlClassName) {
        if (wrapClassName.equals(Wrap.class.getName())) {
            return Dock.class.getName();
        }
        return this.getPackageName(wrapClassName) + "." + this.getSimpleName(controlClassName) + "Dock";
    }

    private String substitutePrimitiveType(String orig) {
        if (this.primitiveTypesSubstitutions.containsKey(orig)) {
            return this.primitiveTypesSubstitutions.get(orig);
        }
        return orig;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment re) {
        for (Element element : re.getElementsAnnotatedWith(ControlType.class)) {
            String wrapClass = ((TypeElement)element).getQualifiedName().toString();
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Wrapper: " + wrapClass);
            AnnotationMirror controlTypeAnn = this.findAnnotations(element, ControlType.class).get(0);
            for (String controlClassName : this.getElementValue(controlTypeAnn, "value").accept(new ClassArrayValueGetter(), null)) {
                boolean needsSubtypeLookups;
                String dockClassName = this.generateDockName(element, controlClassName);
                String dockPackage = this.getPackageName(dockClassName);
                String dockShortName = this.getSimpleName(dockClassName);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating " + dockPackage + "." + dockShortName + " for " + controlClassName);
                String wrapSuperClass = ((TypeElement)element).getSuperclass().accept(new TypeNameGetter(), null);
                String superControlClassName = ((TypeElement)element).getSuperclass().accept(new SuperWrapClassNamesGetter(), null);
                String superDockClassName = this.generateDockName(((DeclaredType)((TypeElement)element).getSuperclass()).asElement(), superControlClassName);
                StringBuilder body = this.replace(body_source, PACKAGE_PLACEHOLDER, dockPackage, DOCK_PLACEHOLDER, dockShortName, SUPERDOCK_PLACEHOLDER, superDockClassName, WRAP_PLACEHOLDER, wrapClass);
                TypeMirror mirror = element.asType();
                String defaultWrapperMethod = null;
                String defaultParentMethod = null;
                String defaultParentDescription = null;
                boolean anonymous = false;
                while (!mirror.accept(new TypeNameGetter(), null).equals(Wrap.class.getName())) {
                    DockInfo di;
                    Element typeEl = ((DeclaredType)mirror).asElement();
                    if (!anonymous && (di = element.getAnnotation(DockInfo.class)) != null) {
                        anonymous = di.anonymous();
                    }
                    for (Element element2 : typeEl.getEnclosedElements()) {
                        DefaultWrapper defaultWrapperAnn;
                        DefaultParent defaultParentAnn;
                        if (defaultParentMethod == null && (defaultParentAnn = element2.getAnnotation(DefaultParent.class)) != null) {
                            defaultParentMethod = ((TypeElement)((DeclaredType)mirror).asElement()).getQualifiedName() + "." + element2.getSimpleName();
                            defaultParentDescription = defaultParentAnn.value();
                        }
                        if (defaultWrapperMethod == null && (defaultWrapperAnn = element2.getAnnotation(DefaultWrapper.class)) != null) {
                            defaultWrapperMethod = ((TypeElement)((DeclaredType)mirror).asElement()).getQualifiedName() + "." + element2.getSimpleName();
                        }
                        if (defaultParentMethod == null || defaultWrapperMethod == null) continue;
                        break;
                    }
                    mirror = (DeclaredType)((TypeElement)((DeclaredType)mirror).asElement()).getSuperclass();
                }
                StringBuilder constructors = new StringBuilder();
                if (defaultWrapperMethod != null) {
                    constructors.append((CharSequence)this.replace(control_constructor_source, DOCK_PLACEHOLDER, dockShortName, CONTROL_PLACEHOLDER, controlClassName, "$WRAP_METHOD$", defaultWrapperMethod));
                }
                constructors.append((CharSequence)this.replace(wrap_constructor_source, DOCK_PLACEHOLDER, dockShortName, CONTROL_PLACEHOLDER, controlClassName, "$PUBLIC$", anonymous ? "protected" : "public"));
                constructors.append((CharSequence)this.replace(criteria_constructors_source, DOCK_PLACEHOLDER, dockShortName, CONTROL_PLACEHOLDER, controlClassName));
                boolean bl = needsSubtypeLookups = element.getAnnotation(DockInfo.class) != null && element.getAnnotation(DockInfo.class).generateSubtypeLookups();
                if (needsSubtypeLookups) {
                    constructors.append((CharSequence)this.replace(criteria_subclass_constructors_source, DOCK_PLACEHOLDER, dockShortName, CONTROL_PLACEHOLDER, controlClassName));
                }
                if (defaultParentMethod != null) {
                    constructors.append((CharSequence)this.replace(default_parent_criteria_constructors_source, DOCK_PLACEHOLDER, dockShortName, CONTROL_PLACEHOLDER, controlClassName, "$LOOKUP_METHOD$", defaultParentMethod, "$DEFAULT_PARENT_DESCRIPTION$", defaultParentDescription));
                    if (needsSubtypeLookups) {
                        constructors.append((CharSequence)this.replace(default_parent_criteria_subclass_constructors_source, DOCK_PLACEHOLDER, dockShortName, CONTROL_PLACEHOLDER, controlClassName, "$LOOKUP_METHOD$", defaultParentMethod, "$DEFAULT_PARENT_DESCRIPTION$", defaultParentDescription));
                    }
                }
                ObjectLookupTable objectLookupTable = new ObjectLookupTable((TypeElement)element);
                for (int i = 0; i < objectLookupTable.names.size(); ++i) {
                    String mn = objectLookupTable.methodNames.get(i);
                    StringBuilder declaredParameters = new StringBuilder();
                    StringBuilder usedParameters = new StringBuilder(mn + "($LOOKUP_SUBTYPE$");
                    for (int j = 0; j < objectLookupTable.types.get(i).size(); ++j) {
                        usedParameters.append(", ");
                        if (j > 0) {
                            declaredParameters.append(", ");
                        }
                        usedParameters.append(objectLookupTable.names.get(i).get(j));
                        declaredParameters.append(objectLookupTable.types.get(i).get(j)).append(" ").append(objectLookupTable.names.get(i).get(j));
                    }
                    usedParameters.append(")");
                    String comma = objectLookupTable.types.get(i).size() > 0 ? "," : "";
                    constructors.append((CharSequence)this.replace(object_lookup_constructors_source, DOCK_PLACEHOLDER, dockShortName, CONTROL_PLACEHOLDER, controlClassName, "$DECLARED_PARAMETERS$", declaredParameters.toString(), "$USED_PARAMETERS$", usedParameters.toString(), "$LOOKUP_SUBTYPE$", controlClassName + ".class", "$LOOKUP_DESCRIPTION$", objectLookupTable.comments.get(i), "$COMMA$", comma));
                    if (needsSubtypeLookups) {
                        constructors.append((CharSequence)this.replace(object_lookup_subclass_constructors_source, DOCK_PLACEHOLDER, dockShortName, CONTROL_PLACEHOLDER, controlClassName, "$DECLARED_PARAMETERS$", declaredParameters.toString(), "$USED_PARAMETERS$", usedParameters.toString(), "$LOOKUP_SUBTYPE$", "cls", "$LOOKUP_DESCRIPTION$", objectLookupTable.comments.get(i), "$COMMA$", comma));
                    }
                    if (defaultParentMethod == null) continue;
                    constructors.append((CharSequence)this.replace(default_parent_object_lookup_constructors_source, DOCK_PLACEHOLDER, dockShortName, CONTROL_PLACEHOLDER, controlClassName, "$LOOKUP_METHOD$", defaultParentMethod, "$DEFAULT_PARENT_DESCRIPTION$", defaultParentDescription, "$DECLARED_PARAMETERS$", declaredParameters.toString(), "$USED_PARAMETERS$", usedParameters.toString(), "$LOOKUP_SUBTYPE$", controlClassName + ".class", "$LOOKUP_DESCRIPTION$", objectLookupTable.comments.get(i), "$COMMA$", comma));
                    if (!needsSubtypeLookups) continue;
                    constructors.append((CharSequence)this.replace(default_parent_object_lookup_subclass_constructors_source, DOCK_PLACEHOLDER, dockShortName, CONTROL_PLACEHOLDER, controlClassName, "$LOOKUP_METHOD$", defaultParentMethod, "$DEFAULT_PARENT_DESCRIPTION$", defaultParentDescription, "$DECLARED_PARAMETERS$", declaredParameters.toString(), "$USED_PARAMETERS$", usedParameters.toString(), "$LOOKUP_SUBTYPE$", "cls", "$LOOKUP_DESCRIPTION$", objectLookupTable.comments.get(i), "$COMMA$", comma));
                }
                this.replace(body, "$CONSTRUCTORS$", constructors.toString());
                this.replace(body, "$WRAP_GETTER$", this.replace(anonymous ? anon_wrap_getter_source : wrap_getter_source, CONTROL_PLACEHOLDER, controlClassName, WRAP_PLACEHOLDER, wrapClass).toString());
                StringBuilder interfaces = new StringBuilder();
                List<AnnotationMirror> controlInterfacesAnns = this.findAnnotations(element, ControlInterfaces.class);
                HashSet<TypeElement> visitedNodes = new HashSet<TypeElement>();
                for (AnnotationMirror am : controlInterfacesAnns) {
                    List<String> intrfcs = this.getElementValue(am, "value").accept(new ClassArrayValueGetter(), null);
                    Object var30_37 = null;
                    AnnotationValue av = this.getElementValue(am, "encapsulates");
                    if (av != null) {
                        List<String> list = av.accept(new ClassArrayValueGetter(), null);
                    }
                    List name = null;
                    av = this.getElementValue(am, "name");
                    if (av != null) {
                        name = (List)av.getValue();
                    }
                    for (int i = 0; i < intrfcs.size(); ++i) {
                        void var30_39;
                        String innerType = var30_39 != null && var30_39.size() > i ? (String)var30_39.get(i) : null;
                        StringBuilder one_interface_getter = this.replace(innerType != null ? typed_interface_getter_source : interface_getter_source, "$INTERFACE$", intrfcs.get(i));
                        if (innerType != null) {
                            this.replace(one_interface_getter, "$INTERFACE_TYPE$", innerType);
                        }
                        String nm = name != null && name.size() > i ? (String)((AnnotationValue)name.get(i)).getValue() : "as" + this.getSimpleName(intrfcs.get(i));
                        this.replace(one_interface_getter, "$INTERFACE_GETTER$", nm);
                        interfaces.append((CharSequence)one_interface_getter);
                    }
                    interfaces.append(this.generateInterfaceShorcuts(am, visitedNodes));
                }
                visitedNodes.clear();
                this.replace(body, "$INTERFACES$", interfaces.toString());
                StringBuilder properties = new StringBuilder();
                this.addReflectionProperties(properties, element, MethodProperties.class, method_property_getter_source);
                this.addReflectionProperties(properties, element, FieldProperties.class, field_property_getter_source);
                HashMap<String, String> declaresProperties = new HashMap<String, String>();
                for (Element element3 : ((TypeElement)element).getEnclosedElements()) {
                    for (AnnotationMirror am : this.findAnnotations(element3, Property.class)) {
                        declaresProperties.put((String)this.getElementValue(am, "value").getValue(), ((ExecutableElement)element3).getReturnType().toString());
                        String propString = (String)this.getElementValue(am, "value").getValue();
                        properties.append((CharSequence)this.replace(anonymous ? anon_declared_property_getter_source : declared_property_getter_source, "$PROP_NAME$", propString, "$PROP_TYPE$", this.substitutePrimitiveType(((ExecutableElement)element3).getReturnType().toString()), "$GETTER_NAME$", this.createGetterName(propString), "$METHOD_NAME$", ((ExecutableElement)element3).getSimpleName().toString()));
                    }
                }
                this.replace(body, "$PROPERTIES$", properties.toString());
                try {
                    JavaFileObject f = this.processingEnv.getFiler().createSourceFile(dockPackage + "." + dockShortName, new Element[0]);
                    Writer writer = f.openWriter();
                    PrintWriter pw = new PrintWriter(writer);
                    pw.print(body);
                    pw.flush();
                    pw.close();
                }
                catch (IOException ex) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, ex.getMessage());
                }
            }
        }
        return true;
    }

    private String generateInterfaceShorcuts(AnnotationMirror am, HashSet<TypeElement> visitedNodes) {
        StringBuilder shortcuts = new StringBuilder();
        List interfaces = (List)this.getElementValue(am, "value").getValue();
        for (AnnotationValue iface : interfaces) {
            TypeElement e = iface.accept(new SimpleAnnotationValueVisitor6<TypeElement, Object>(){

                @Override
                public TypeElement visitType(TypeMirror t, Object p) {
                    return (TypeElement)((DeclaredType)t).asElement();
                }
            }, null);
            if (e.getKind() == ElementKind.CLASS) {
                this.shortcutsClassesBypass(e, shortcuts, visitedNodes);
                continue;
            }
            if (e.getKind() != ElementKind.INTERFACE && e.getKind() != ElementKind.ENUM) continue;
            this.shortcutsInterfacesBypass(e, shortcuts, visitedNodes);
        }
        return shortcuts.toString();
    }

    private void shortcutsClassesBypass(TypeElement e, StringBuilder shortcuts, HashSet<TypeElement> visitedNodes) {
        if (e == null) {
            return;
        }
        TypeMirror supperC = e.getSuperclass();
        if (supperC.getKind() != TypeKind.NONE) {
            this.shortcutsClassesBypass((TypeElement)this.processingEnv.getTypeUtils().asElement(supperC), shortcuts, visitedNodes);
            this.shortcutsInterfacesBypass(e, shortcuts, visitedNodes);
        } else {
            this.shortcutsInterfacesBypass(e, shortcuts, visitedNodes);
        }
    }

    private void shortcutsInterfacesBypass(TypeElement e, StringBuilder shortcuts, HashSet<TypeElement> visitedNodes) {
        if (e == null) {
            return;
        }
        List<? extends TypeMirror> innerFaces = e.getInterfaces();
        for (TypeMirror typeMirror : innerFaces) {
            if (!this.IsAppropriateNode(typeMirror)) continue;
            this.shortcutsInterfacesBypass((TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror), shortcuts, visitedNodes);
        }
        if (this.IsAppropriateNode(e.asType()) && visitedNodes.add(e)) {
            this.handleInterfaceShorcuts(e, shortcuts);
        }
    }

    private boolean IsAppropriateNode(TypeMirror eM) {
        return this.processingEnv.getTypeUtils().isSubtype(eM, this.processingEnv.getElementUtils().getTypeElement(ControlInterface.class.getName()).asType()) && !this.processingEnv.getTypeUtils().isSameType(eM, this.processingEnv.getElementUtils().getTypeElement(ControlInterface.class.getName()).asType());
    }

    private void handleInterfaceShorcuts(TypeElement e, StringBuilder shortcuts) {
        for (Element element : ElementFilter.methodsIn(this.processingEnv.getElementUtils().getAllMembers(e))) {
            String returnTypeString;
            if (element.getEnclosingElement() != e || element.getAnnotation(Shortcut.class) == null) continue;
            StringBuilder setter = new StringBuilder().append(element.getAnnotation(Shortcut.class).name().equals("") ? ((ExecutableElement)element).getSimpleName() : element.getAnnotation(Shortcut.class).name()).append('(');
            StringBuilder invokeSetter = new StringBuilder().append(((ExecutableElement)element).getSimpleName()).append('(');
            TypeMirror returnType = ((ExecutableElement)element).getReturnType();
            if (returnType.getKind() == TypeKind.TYPEVAR) {
                returnTypeString = "Object";
            } else {
                returnTypeString = returnType.toString();
                int genericStartIndex = returnType.toString().indexOf("<");
                if (genericStartIndex > -1) {
                    returnTypeString = returnTypeString.substring(0, genericStartIndex) + "<?>";
                }
            }
            boolean firstParameter = true;
            for (VariableElement variableElement : ((ExecutableElement)element).getParameters()) {
                if (!firstParameter) {
                    setter.append(", ");
                    invokeSetter.append(", ");
                }
                setter.append(variableElement.asType().toString()).append(" ").append(variableElement.getSimpleName());
                invokeSetter.append(variableElement.getSimpleName());
                firstParameter = false;
            }
            setter.append(")");
            invokeSetter.append(")");
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "generating setter " + setter);
            shortcuts.append((CharSequence)this.replace(shortcut_methods_source, "$RETURN_TYPE$", returnTypeString, "$RETURN_STATEMENT$", returnTypeString.equals("void") ? "" : "return ", "$INTERFACE_SETTER$", setter.toString(), "$INVOKE_SETTER$", invokeSetter.toString(), "$INTERFACE$", e.getQualifiedName().toString()));
        }
    }

    private void addReflectionProperties(StringBuilder source, Element e, Class annClass, String template) {
        List<AnnotationMirror> propsAnn = this.findAnnotations(e, annClass);
        if (propsAnn.size() > 0) {
            List<String> props = this.getElementValue(propsAnn.get(0), "value").accept(new StringArrayValueGetter(), null);
            AnnotationValue typesValue = this.getElementValue(propsAnn.get(0), "types");
            List<Object> propsTypes = typesValue != null ? typesValue.accept(new ClassArrayValueGetter(), null) : new LinkedList();
            for (int i = 0; i < props.size(); ++i) {
                String propString = props.get(i);
                String propType = propsTypes.size() > i ? (String)propsTypes.get(i) : Object.class.getName();
                source.append((CharSequence)this.replace(template, "$PROP_NAME$", props.get(i), "$PROP_TYPE$", this.substitutePrimitiveType(propType), "$GETTER_NAME$", this.createGetterName(propString)));
            }
        }
    }

    private String toLowerCaseCamel(String camel) {
        return camel.substring(0, 1).toLowerCase() + camel.substring(1);
    }

    private String toUpperCaseCamel(String camel) {
        StringBuilder res = new StringBuilder(camel);
        res.replace(0, 1, res.substring(0, 1).toUpperCase());
        int dot = res.indexOf(".");
        while (dot > 0) {
            res.delete(dot, dot + 1);
            if (res.length() > dot) {
                res.replace(dot, dot + 1, res.substring(dot, dot + 1).toUpperCase());
            }
            dot = res.indexOf(".");
        }
        return res.toString();
    }

    private String unQuote(Object data) {
        return data.toString().substring(1, data.toString().length() - 1);
    }

    private AnnotationValue getElementValue(AnnotationMirror am, String name) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = am.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.getSimpleName().contentEquals(name)) continue;
            return values.get(executableElement);
        }
        return null;
    }

    private List<AnnotationMirror> findAnnotations(Element e, Class annotationType) {
        LinkedList<AnnotationMirror> res = new LinkedList<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationType.getName())) continue;
            res.add(annotationMirror);
        }
        return res;
    }

    private String getPackageName(String fullName) {
        return fullName.substring(0, fullName.lastIndexOf("."));
    }

    private String getSimpleName(String className) {
        return className.substring(className.lastIndexOf(".") + 1);
    }

    private String createGetterName(String propString) {
        String result = !propString.startsWith("get") && !propString.startsWith("is") ? "get" + this.toUpperCaseCamel(propString) : propString;
        return result.replace('.', '_');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SuperWrapClassNamesGetter
    extends AbstractTypeVisitor6<String, Object> {
        @Override
        public String visitDeclared(DeclaredType dt, Object p) {
            AnnotationMirror controlTypeAnn = (AnnotationMirror)DockGenerator.this.findAnnotations(dt.asElement(), ControlType.class).get(0);
            return DockGenerator.this.getElementValue(controlTypeAnn, "value").accept(new ClassArrayValueGetter(), null).get(0);
        }

        @Override
        public String visitPrimitive(PrimitiveType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitNull(NullType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitArray(ArrayType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitError(ErrorType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitTypeVariable(TypeVariable t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitWildcard(WildcardType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitExecutable(ExecutableType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitNoType(NoType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringArrayValueGetter
    extends AbstractAnnotationValueVisitor6<List<String>, Object> {
        @Override
        public List<String> visitArray(List<? extends AnnotationValue> list, Object p) {
            ArrayList<String> res = new ArrayList<String>();
            for (AnnotationValue annotationValue : list) {
                res.add(annotationValue.getValue().toString());
            }
            return res;
        }

        @Override
        public List<String> visitBoolean(boolean b, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitByte(byte b, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitChar(char c, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitDouble(double d, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitFloat(float f, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitInt(int i, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitLong(long i, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitShort(short s, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitString(String s, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitType(TypeMirror t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitEnumConstant(VariableElement c, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitAnnotation(AnnotationMirror a, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeNameGetter
    extends AbstractTypeVisitor6<String, Object> {
        @Override
        public String visitDeclared(DeclaredType dt, Object p) {
            return ((TypeElement)dt.asElement()).getQualifiedName().toString();
        }

        @Override
        public String visitPrimitive(PrimitiveType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitNull(NullType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitArray(ArrayType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitError(ErrorType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitTypeVariable(TypeVariable t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitWildcard(WildcardType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitExecutable(ExecutableType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitNoType(NoType t, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassArrayValueGetter
    implements AnnotationValueVisitor<List<String>, Object> {
        private ClassArrayValueGetter() {
        }

        @Override
        public List<String> visitArray(List<? extends AnnotationValue> list, Object p) {
            ArrayList<String> result = new ArrayList<String>();
            for (AnnotationValue annotationValue : list) {
                result.add(annotationValue.accept(new ClassValueGetter(), null));
            }
            return result;
        }

        @Override
        public List<String> visitBoolean(boolean bln, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitByte(byte b, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitChar(char c, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitDouble(double d, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitFloat(float f, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitInt(int i, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitLong(long l, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitShort(short s, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitString(String string, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitType(TypeMirror tm, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitEnumConstant(VariableElement ve, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitAnnotation(AnnotationMirror am, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visit(AnnotationValue av, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visit(AnnotationValue av) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> visitUnknown(AnnotationValue av, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassValueGetter
    implements AnnotationValueVisitor<String, Object> {
        private ClassValueGetter() {
        }

        @Override
        public String visit(AnnotationValue av, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visit(AnnotationValue av) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitBoolean(boolean bln, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitByte(byte b, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitChar(char c, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitDouble(double d, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitFloat(float f, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitInt(int i, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitLong(long l, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitShort(short s, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitString(String string, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitType(TypeMirror tm, Object p) {
            return tm.toString();
        }

        @Override
        public String visitEnumConstant(VariableElement ve, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitAnnotation(AnnotationMirror am, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitArray(List<? extends AnnotationValue> list, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String visitUnknown(AnnotationValue av, Object p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectLookupTable {
        List<List<String>> types = new ArrayList<List<String>>();
        List<List<String>> names = new ArrayList<List<String>>();
        List<String> methodNames = new ArrayList<String>();
        List<String> comments = new ArrayList<String>();

        public ObjectLookupTable(TypeElement wrap) {
            TypeMirror mirror = wrap.asType();
            DockGenerator.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "looking for object lookups");
            while (!mirror.accept(new TypeNameGetter(), null).equals(Wrap.class.getName())) {
                TypeElement te = (TypeElement)((DeclaredType)mirror).asElement();
                this.addObjectLookups(te);
                mirror = (DeclaredType)te.getSuperclass();
            }
        }

        private void addObjectLookups(TypeElement wrap) {
            for (Element element : wrap.getEnclosedElements()) {
                List<String> oneTps;
                ObjectLookup ol = element.getAnnotation(ObjectLookup.class);
                if (ol == null) continue;
                boolean foundSameSignature = false;
                DockGenerator.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, element.getSimpleName());
                ArrayList<String> tps = new ArrayList<String>();
                ArrayList<String> nms = new ArrayList<String>();
                List<? extends VariableElement> params = ((ExecutableElement)element).getParameters();
                if (params.isEmpty() || !params.get(0).asType().toString().startsWith(Class.class.getName())) {
                    throw new IllegalStateException("Expect first parameter to ba a class but found " + (params.isEmpty() ? "none" : params.get(0).asType().toString()));
                }
                for (int i = 1; i < ((ExecutableElement)element).getParameters().size(); ++i) {
                    VariableElement param = ((ExecutableElement)element).getParameters().get(i);
                    tps.add(param.asType().toString());
                    nms.add(param.getSimpleName().toString());
                }
                Iterator<List<String>> i$ = this.types.iterator();
                while (i$.hasNext() && !(foundSameSignature = this.compareParamTypesList(oneTps = i$.next(), tps))) {
                }
                if (foundSameSignature) continue;
                this.types.add(tps);
                this.names.add(nms);
                this.methodNames.add(wrap.getQualifiedName() + "." + element.getSimpleName());
                this.comments.add(ol.value().length() > 0 ? "by " + ol.value() : "");
            }
        }

        private boolean compareParamTypesList(List<String> oneTps, List<String> tps) {
            if (oneTps.size() != tps.size()) {
                return false;
            }
            for (int i = 0; i < oneTps.size(); ++i) {
                if (oneTps.get(i).equals(tps.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

