/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jemmy.JemmyException;
import org.jemmy.action.ActionExecutor;
import org.jemmy.action.DefaultExecutor;
import org.jemmy.env.TestOut;
import org.jemmy.env.Timeout;
import org.jemmy.image.ImageCapturer;
import org.jemmy.image.ImageFactory;
import org.jemmy.image.ImageFactoryImpl;
import org.jemmy.image.ImageLoader;
import org.jemmy.input.CharBindingMap;
import org.jemmy.interfaces.ControlInterfaceFactory;
import org.jemmy.timing.Waiter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment {
    public static final String JEMMY_PROPERTIES_FILE_PROPERTY = "jemmy.properties";
    public static final String TIMEOUTS_FILE_PROPERTY = "timeouts";
    public static final String OUTPUT = Environment.class.getName() + ".OUTPUT";
    private static final Environment env = new Environment(null);
    private HashMap<PropertyKey, Object> environment = new HashMap();
    private Environment parent;

    public static Environment getEnvironment() {
        return env;
    }

    public Environment(Environment parent) {
        this.parent = parent;
        this.environment = new HashMap();
        if (parent == null) {
            this.loadProperties();
        }
    }

    public Environment() {
        this(Environment.getEnvironment());
    }

    public Environment getParentEnvironment() {
        return this.parent;
    }

    public void setParentEnvironment(Environment parent) {
        this.parent = parent;
    }

    private void loadProperties() {
        String propFileName = System.getProperty(JEMMY_PROPERTIES_FILE_PROPERTY);
        if (propFileName == null || propFileName.length() == 0) {
            propFileName = System.getProperty("user.home") + File.separator + ".jemmy.properties";
        }
        File propFile = new File(propFileName);
        System.out.println("Loading jemmy properties from " + propFile);
        if (propFile.exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(propFile));
            }
            catch (IOException ex) {
                throw new JemmyException("Unable to load properties", ex, propFileName);
            }
            for (String k : props.stringPropertyNames()) {
                if (k.equals(TIMEOUTS_FILE_PROPERTY)) {
                    this.loadTimeouts(propFile.getParentFile(), props.getProperty(k));
                    continue;
                }
                this.setProperty(k, (Object)props.getProperty(k));
            }
        } else {
            System.out.println("Property file " + propFile + " does not exists. Ignoring.");
        }
    }

    private void loadTimeouts(File propDir, String file) {
        File timeoutsFile = new File(file);
        if (!timeoutsFile.isAbsolute()) {
            timeoutsFile = new File(propDir.getAbsolutePath() + File.separator + file);
        }
        System.out.println("Loading timeouts from " + timeoutsFile.getAbsolutePath());
        try {
            Properties timeouts = new Properties();
            timeouts.load(new FileInputStream(timeoutsFile));
            for (String k : timeouts.stringPropertyNames()) {
                this.setTimeout(k, Long.parseLong(timeouts.getProperty(k)));
            }
        }
        catch (IOException ex) {
            throw new JemmyException("Unable to load timeouts", ex, timeoutsFile.getAbsolutePath());
        }
    }

    public List<?> get(Class cls) {
        Set<PropertyKey> all = this.environment.keySet();
        ArrayList<Object> result = new ArrayList<Object>();
        for (PropertyKey key : all) {
            if (!key.getCls().equals(cls)) continue;
            result.add(this.environment.get(key));
        }
        return result;
    }

    public ActionExecutor setExecutor(ActionExecutor defaultExecutor) {
        return this.setProperty(ActionExecutor.class, defaultExecutor);
    }

    public ActionExecutor getExecutor() {
        ActionExecutor res = this.getProperty(ActionExecutor.class);
        if (res == null) {
            String executorClassName = (String)this.getProperty("action.executor");
            try {
                res = (ActionExecutor)ActionExecutor.class.cast(Class.forName(executorClassName).newInstance());
                this.setExecutor(res);
            }
            catch (InstantiationException ex) {
                throw new JemmyException("Unable to instantiate executor ", ex, executorClassName);
            }
            catch (IllegalAccessException ex) {
                throw new JemmyException("Unable to instantiate executor ", ex, executorClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new JemmyException("No executorclass ", ex, executorClassName);
            }
        }
        return res;
    }

    private <T> T setProperty(Class<T> cls, Object ref, T obj) {
        return this.setProperty(new PropertyKey<T>(cls, ref), obj);
    }

    private <T> T setPropertyIfNotSet(Class<T> cls, Object ref, T obj) {
        return this.setPropertyIfNotSet(new PropertyKey<T>(cls, ref), obj);
    }

    private <T> T getProperty(Class<T> cls, Object ref) {
        return this.getProperty(cls, ref, null);
    }

    private <T> T getProperty(Class cls, Object ref, T defaultValue) {
        for (PropertyKey pk : this.environment.keySet()) {
            if (!pk.equals(new PropertyKey(cls, ref))) continue;
            return (T)this.environment.get(pk);
        }
        if (this.getParentEnvironment() != null) {
            return this.getParentEnvironment().getProperty(cls, ref, defaultValue);
        }
        return defaultValue;
    }

    public <T> T setProperty(Class<T> cls, T obj) {
        return this.setProperty(cls, null, obj);
    }

    public <T> T setPropertyIfNotSet(Class<T> cls, T obj) {
        return this.setPropertyIfNotSet(cls, null, obj);
    }

    public <T> T getProperty(Class<T> cls) {
        return this.getProperty(cls, null);
    }

    public Object setProperty(String name, Object obj) {
        return this.setProperty(Object.class, name, obj);
    }

    public Object setPropertyIfNotSet(String name, Object obj) {
        return this.setPropertyIfNotSet(Object.class, name, obj);
    }

    public Object getProperty(String name) {
        return this.getProperty(Object.class, (Object)name);
    }

    public Object getProperty(String name, Object defaultValue) {
        return this.getProperty(Environment.class, name, defaultValue);
    }

    private <T> T setProperty(PropertyKey<T> key, Object value) {
        if (value == null) {
            return ((PropertyKey)key).cls.cast(this.environment.remove(key));
        }
        return ((PropertyKey)key).cls.cast(this.environment.put(key, value));
    }

    private <T> T setPropertyIfNotSet(PropertyKey<T> key, T value) {
        Object res;
        if (this.getParentEnvironment() != null && (res = ((PropertyKey)key).cls.cast(this.getParentEnvironment().getProperty(key))) != null) {
            return res;
        }
        res = ((PropertyKey)key).cls.cast(this.environment.get(key));
        if (res == null) {
            return ((PropertyKey)key).cls.cast(this.environment.put(key, value));
        }
        return res;
    }

    private Object getProperty(PropertyKey key) {
        return this.environment.get(key);
    }

    public TestOut setOutput(TestOut out) {
        return this.setProperty(TestOut.class, out);
    }

    public TestOut getOutput() {
        return this.getProperty(TestOut.class);
    }

    public TestOut setOutput(String outputName, TestOut out) {
        return this.setProperty(TestOut.class, outputName, out);
    }

    public TestOut initOutput(String outputName, TestOut out) {
        TestOut res = this.getProperty(TestOut.class, (Object)outputName);
        if (res == null) {
            return this.setOutput(outputName, out);
        }
        return res;
    }

    public TestOut getOutput(String outputName) {
        TestOut res = this.getProperty(TestOut.class, (Object)outputName);
        return res != null ? res : this.getOutput();
    }

    public Waiter getWaiter(Timeout timeout) {
        return this.getWaiter(timeout.getName());
    }

    public Waiter getWaiter(String timeoutName) {
        return new Waiter(this.getTimeout(timeoutName));
    }

    public Timeout getTimeout(Timeout timeout) {
        return this.getTimeout(timeout.getName());
    }

    public Timeout getTimeout(String name) {
        return this.getProperty(Timeout.class, (Object)name);
    }

    public Timeout setTimeout(Timeout timeout) {
        return this.setProperty(Timeout.class, timeout.getName(), timeout);
    }

    public Timeout initTimeout(Timeout timeout) {
        if (this.getProperty(Timeout.class, (Object)timeout.getName()) == null) {
            return this.setTimeout(timeout);
        }
        return this.getTimeout(timeout);
    }

    public Timeout setTimeout(Timeout timeout, long value) {
        return this.setTimeout(timeout.getName(), value);
    }

    public Timeout setTimeout(String name, long value) {
        return this.setTimeout(new Timeout(name, value));
    }

    public CharBindingMap getBindingMap() {
        return this.getProperty(CharBindingMap.class);
    }

    public CharBindingMap setBindingMap(CharBindingMap map) {
        return this.setProperty(CharBindingMap.class, map);
    }

    public ImageFactory getImageFactory() {
        ImageFactory res = this.getProperty(ImageFactory.class);
        if (res == null) {
            ImageCapturer imageCapturer = this.getImageCapturer();
            ImageLoader imageLoader = this.getImageLoader();
            if (imageCapturer != null && imageLoader != null) {
                return new ImageFactoryImpl(imageCapturer, imageLoader);
            }
            String factoryClass = (String)this.getProperty("image.factory");
            if (factoryClass == null) {
                return null;
            }
            try {
                res = (ImageFactory)ImageFactory.class.cast(Class.forName((String)String.class.cast(factoryClass)).newInstance());
                this.setImageFactory(res);
            }
            catch (InstantiationException ex) {
                throw new JemmyException("Unable to instantiate image factory ", ex, factoryClass);
            }
            catch (IllegalAccessException ex) {
                throw new JemmyException("Unable to instantiate image factory ", ex, factoryClass);
            }
            catch (ClassNotFoundException ex) {
                throw new JemmyException("No image factory class ", ex, factoryClass);
            }
        }
        return res;
    }

    public ImageLoader getImageLoader() {
        ImageLoader res = this.getProperty(ImageLoader.class);
        if (res == null) {
            String loaderClass = (String)this.getProperty("image.loader");
            ImageFactory imageFactory = this.getProperty(ImageFactory.class);
            if (loaderClass == null) {
                return imageFactory;
            }
            try {
                res = (ImageLoader)ImageLoader.class.cast(Class.forName((String)String.class.cast(loaderClass)).newInstance());
                this.setImageLoader(res);
            }
            catch (InstantiationException ex) {
                throw new JemmyException("Unable to instantiate image loader ", ex, loaderClass);
            }
            catch (IllegalAccessException ex) {
                throw new JemmyException("Unable to instantiate image loader ", ex, loaderClass);
            }
            catch (ClassNotFoundException ex) {
                throw new JemmyException("No image loader class ", ex, loaderClass);
            }
        }
        return res;
    }

    public ImageCapturer getImageCapturer() {
        ImageCapturer res = this.getProperty(ImageCapturer.class);
        if (res == null) {
            String capturerClass = (String)this.getProperty("image.capturer");
            ImageFactory imageFactory = this.getProperty(ImageFactory.class);
            if (capturerClass == null) {
                return imageFactory;
            }
            try {
                res = (ImageCapturer)ImageCapturer.class.cast(Class.forName((String)String.class.cast(capturerClass)).newInstance());
                this.setImageCapturer(res);
            }
            catch (InstantiationException ex) {
                throw new JemmyException("Unable to instantiate image capturer ", ex, capturerClass);
            }
            catch (IllegalAccessException ex) {
                throw new JemmyException("Unable to instantiate image capturer ", ex, capturerClass);
            }
            catch (ClassNotFoundException ex) {
                throw new JemmyException("No image capturer class ", ex, capturerClass);
            }
        }
        return res;
    }

    public ImageFactory setImageFactory(ImageFactory factory) {
        if (factory instanceof ImageFactoryImpl) {
            ImageFactoryImpl impl = (ImageFactoryImpl)factory;
            this.setImageCapturer(impl.getImageCapturer());
            this.setImageLoader(impl.getImageLoader());
        }
        return this.setProperty(ImageFactory.class, factory);
    }

    public ImageLoader setImageLoader(ImageLoader imageLoader) {
        return this.setProperty(ImageLoader.class, imageLoader);
    }

    public ImageCapturer setImageCapturer(ImageCapturer imageCapturer) {
        this.getOutput(OUTPUT).println("ImageCapturer set to " + imageCapturer);
        return this.setProperty(ImageCapturer.class, imageCapturer);
    }

    public ControlInterfaceFactory getInputFactory() {
        String factoryClass;
        ControlInterfaceFactory res = this.getProperty(ControlInterfaceFactory.class);
        if (res == null && (factoryClass = (String)this.getProperty("input.control.interface.factory")) != null) {
            try {
                res = (ControlInterfaceFactory)ControlInterfaceFactory.class.cast(Class.forName((String)String.class.cast(factoryClass)).newInstance());
                this.setInputFactory(res);
            }
            catch (InstantiationException ex) {
                throw new JemmyException("Unable to instantiate input factory", ex, factoryClass);
            }
            catch (IllegalAccessException ex) {
                throw new JemmyException("Unable to instantiate input factory", ex, factoryClass);
            }
            catch (ClassNotFoundException ex) {
                throw new JemmyException("Unable to load input factory", ex, factoryClass);
            }
        }
        return res;
    }

    public ControlInterfaceFactory setInputFactory(ControlInterfaceFactory factory) {
        this.getOutput(OUTPUT).println("Input factory set to " + factory);
        return this.setProperty(ControlInterfaceFactory.class, factory);
    }

    static {
        env.setOutput(new TestOut(System.in, System.out, System.err));
        env.setExecutor(new DefaultExecutor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyKey<TYPE> {
        private Class<TYPE> cls;
        private Object ref;

        public PropertyKey(Class<TYPE> cls, Object ref) {
            this.cls = cls;
            this.ref = ref;
        }

        private PropertyKey(Class<TYPE> cls) {
            this(cls, null);
        }

        public Class<TYPE> getCls() {
            return this.cls;
        }

        public Object getRef() {
            return this.ref;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyKey other = (PropertyKey)obj;
            if (!(this.cls == other.cls || this.cls != null && this.cls.equals(other.cls))) {
                return false;
            }
            return this.ref == other.ref || this.ref != null && this.ref.equals(other.ref);
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + (this.cls != null ? this.cls.hashCode() : 0);
            hash = 41 * hash + (this.ref != null ? this.ref.hashCode() : 0);
            return hash;
        }
    }
}

