/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.env;

import org.jemmy.JemmyException;
import org.jemmy.TimeoutExpiredException;

public class Timeout
implements Cloneable {
    private String name;
    private long value;
    private long startTime;

    public Timeout(String name, long value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public void sleep() {
        if (this.getValue() > 0L) {
            try {
                Thread.sleep(this.getValue());
            }
            catch (InterruptedException e) {
                throw new JemmyException("Sleep " + this.getName() + " was interrupted!", e);
            }
        }
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.startTime > this.getValue();
    }

    public void check() {
        if (this.expired()) {
            throw new TimeoutExpiredException(this.getName() + " timeout expired!");
        }
    }

    public String toString() {
        return "Timeout [" + this.name + ", " + this.value + "]";
    }

    public Timeout clone() {
        return new Timeout(this.name, this.value);
    }
}

