/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.pixel;

import org.jemmy.Dimension;
import org.jemmy.image.pixel.Raster;
import org.jemmy.image.pixel.RasterComparator;
import org.jemmy.image.pixel.WriteableRaster;

public abstract class ColorMappingComparator
implements RasterComparator {
    private final ColorMap left;
    private final ColorMap right;
    private RasterComparator subComparator;

    public ColorMappingComparator(ColorMap left, ColorMap right, RasterComparator subComparator) {
        this.subComparator = subComparator;
        this.left = left;
        this.right = right;
    }

    public RasterComparator getSubComparator() {
        return this.subComparator;
    }

    public void setSubComparator(RasterComparator subComparator) {
        this.subComparator = subComparator;
    }

    public ColorMappingComparator(ColorMap both, RasterComparator subComparator) {
        this(both, both, subComparator);
    }

    public boolean compare(Raster image1, Raster image2) {
        return this.subComparator.compare(this.map(image1, this.left), this.map(image2, this.right));
    }

    public WriteableRaster map(Raster image, ColorMap map) {
        WriteableRaster res = this.createView(image.getSize());
        double[] colors = new double[image.getSupported().length];
        double[] newColors = new double[image.getSupported().length];
        for (int x = 0; x < image.getSize().width; ++x) {
            for (int y = 0; y < image.getSize().height; ++y) {
                image.getColors(x, y, colors);
                map.map(image.getSupported(), colors, newColors);
                res.setColors(x, y, newColors);
            }
        }
        return res;
    }

    protected abstract WriteableRaster createView(Dimension var1);

    public String getID() {
        return ColorMappingComparator.class.getName() + ":" + this.left.getID() + "," + this.right.getID() + "(" + this.subComparator.getID() + ")";
    }

    public static interface ColorMap {
        public void map(Raster.Component[] var1, double[] var2, double[] var3);

        public String getID();
    }
}

